/*
 * Decompiled with CFR 0.152.
 */
package com.froobworld.viewdistancetweaks.util;

import java.util.ArrayList;
import java.util.List;

public class RectangleUnionAreaFinder {
    private final List<Rect> rectSet = new ArrayList<Rect>();
    private int area = 0;

    public RectangleUnionAreaFinder addRect(int x0, int y0, int x1, int y1) {
        Rect addingRect = new Rect(x0, y0, x1, y1);
        ArrayList<Rect> newRects = new ArrayList<Rect>();
        ArrayList<Rect> newNewRects = new ArrayList<Rect>();
        newRects.add(addingRect);
        for (Rect rect : this.rectSet) {
            if (addingRect.xMax <= rect.xMin || addingRect.xMin >= rect.xMax || addingRect.yMax <= rect.yMin || addingRect.yMin >= rect.yMax) continue;
            newNewRects.clear();
            for (Rect newRect : newRects) {
                newRect.getRectDifference(rect, newNewRects);
            }
            ArrayList<Rect> oldNewRects = newRects;
            newRects = newNewRects;
            newNewRects = oldNewRects;
        }
        for (Rect rect : newRects) {
            this.area += rect.area();
        }
        this.rectSet.add(addingRect);
        return this;
    }

    public int area() {
        return this.area;
    }

    private static class Rect {
        public final int xMax;
        public final int yMax;
        public final int xMin;
        public final int yMin;

        private Rect(int x0, int y0, int x1, int y1) {
            this.xMax = Math.max(x0, x1);
            this.yMax = Math.max(y0, y1);
            this.xMin = Math.min(x0, x1);
            this.yMin = Math.min(y0, y1);
        }

        public int area() {
            return (this.xMax - this.xMin) * (this.yMax - this.yMin);
        }

        public List<Rect> getRectDifference(Rect otherRect, List<Rect> list) {
            if (this.xMax <= otherRect.xMin || this.xMin >= otherRect.xMax || this.yMax <= otherRect.yMin || this.yMin >= otherRect.yMax) {
                list.add(this);
                return list;
            }
            int xMin = this.xMin;
            int xMax = otherRect.xMin;
            int yMin = this.yMin;
            int yMax = this.yMax;
            if (xMin < xMax && yMin < yMax) {
                list.add(new Rect(xMin, yMin, xMax, yMax));
            }
            xMin = Math.max(otherRect.xMin, this.xMin);
            xMax = Math.min(otherRect.xMax, this.xMax);
            yMin = otherRect.yMax;
            yMax = this.yMax;
            if (xMin < xMax && yMin < yMax) {
                list.add(new Rect(xMin, yMin, xMax, yMax));
            }
            xMin = otherRect.xMax;
            xMax = this.xMax;
            yMin = this.yMin;
            yMax = this.yMax;
            if (xMin < xMax && yMin < yMax) {
                list.add(new Rect(xMin, yMin, xMax, yMax));
            }
            xMin = Math.max(otherRect.xMin, this.xMin);
            xMax = Math.min(otherRect.xMax, this.xMax);
            yMin = this.yMin;
            yMax = otherRect.yMin;
            if (xMin < xMax && yMin < yMax) {
                list.add(new Rect(xMin, yMin, xMax, yMax));
            }
            return list;
        }
    }
}

