/*
 * Decompiled with CFR 0.152.
 */
package com.froobworld.viewdistancetweaks.util;

import com.froobworld.viewdistancetweaks.hook.tick.TickHook;
import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.Queue;
import java.util.concurrent.TimeUnit;
import java.util.function.Consumer;

public class MsptTracker {
    private static final long MILLIS_PER_NANOS = TimeUnit.MILLISECONDS.toNanos(1L);
    private final Consumer<Integer> tickStartConsumer = this::onTickStart;
    private final Consumer<Integer> tickEndConsumer = this::onTickEnd;
    private final TickHook tickHook;
    private final int collectionPeriod;
    private final Queue<Long> tickDurations;
    private int lastTickNumber;
    private long lastTickStartTime;
    private Double cachedMspt;

    public MsptTracker(int collectionPeriod, TickHook tickHook) {
        this.tickHook = tickHook;
        this.collectionPeriod = collectionPeriod <= 0 ? 1200 : collectionPeriod;
        this.tickDurations = new ArrayDeque<Long>();
    }

    public void register() {
        this.tickHook.addTickStartCallback(this.tickStartConsumer);
        this.tickHook.addTickEndCallback(this.tickEndConsumer);
    }

    public void unregister() {
        this.tickHook.removeTickStartCallback(this.tickStartConsumer);
        this.tickHook.removeTickEndCallback(this.tickEndConsumer);
        this.lastTickStartTime = 0L;
        this.tickDurations.clear();
    }

    public double getMspt() {
        if (this.cachedMspt == null) {
            ArrayList<Long> sortedTickDurations = new ArrayList<Long>(this.tickDurations);
            sortedTickDurations.sort(null);
            this.cachedMspt = sortedTickDurations.isEmpty() ? Double.valueOf(25.0) : (sortedTickDurations.size() % 2 == 0 ? Double.valueOf(0.5 * (double)((Long)sortedTickDurations.get(sortedTickDurations.size() / 2) + (Long)sortedTickDurations.get(sortedTickDurations.size() / 2 - 1)) / (double)MILLIS_PER_NANOS) : Double.valueOf(0.5 * (double)((Long)sortedTickDurations.get(sortedTickDurations.size() / 2)).longValue() / (double)MILLIS_PER_NANOS));
        }
        return this.cachedMspt;
    }

    private void onTickStart(int tickNumber) {
        this.lastTickStartTime = System.nanoTime();
        this.lastTickNumber = tickNumber;
        this.cachedMspt = null;
    }

    private void onTickEnd(int tickNumber) {
        if (tickNumber == this.lastTickNumber) {
            long curTimeNanos = System.nanoTime();
            if (this.tickDurations.size() >= this.collectionPeriod) {
                this.tickDurations.remove();
            }
            this.tickDurations.add(curTimeNanos - this.lastTickStartTime);
        }
        this.cachedMspt = null;
    }
}

