/*
 * Decompiled with CFR 0.152.
 */
package com.froobworld.viewdistancetweaks.util;

import java.util.ArrayList;
import java.util.Collection;
import java.util.function.Function;
import java.util.stream.Collectors;
import org.bukkit.ChatColor;
import org.bukkit.command.CommandSender;

public class CommandUtils {
    public static boolean permissionCheck(CommandSender sender, String permission) {
        if (!sender.hasPermission(permission)) {
            sender.sendMessage(ChatColor.RED + "You don't have permission to use this command.");
            return false;
        }
        return true;
    }

    public static <T> String collectionToString(Collection<? extends T> collection, Function<T, String> stringFunction) {
        return collection.stream().map(stringFunction).collect(Collectors.joining(", "));
    }

    public static String collectionToString(Collection<?> collection) {
        return CommandUtils.collectionToString(collection, Object::toString);
    }

    public static String[] getFlagArgs(String flagName, String[] args) {
        boolean reachedFlag = false;
        ArrayList<String> flagArgs = new ArrayList<String>();
        for (String arg : args) {
            if (reachedFlag && arg.startsWith("--")) break;
            if (reachedFlag) {
                flagArgs.add(arg);
            }
            if (!arg.equalsIgnoreCase("--" + flagName)) continue;
            reachedFlag = true;
        }
        return flagArgs.toArray(new String[0]);
    }

    public static String[] getNonFlagArgs(String[] args) {
        ArrayList<String> nonFlagArgs = new ArrayList<String>();
        for (String arg : args) {
            if (arg.startsWith("--")) break;
            nonFlagArgs.add(arg);
        }
        return nonFlagArgs.toArray(new String[0]);
    }
}

