/*
 * Decompiled with CFR 0.152.
 */
package com.froobworld.viewdistancetweaks.metrics;

import com.froobworld.viewdistancetweaks.ViewDistanceTweaks;
import com.froobworld.viewdistancetweaks.hook.tick.PaperTickHook;
import com.froobworld.viewdistancetweaks.lib.bstats.bukkit.Metrics;
import com.froobworld.viewdistancetweaks.lib.bstats.charts.SimplePie;
import com.froobworld.viewdistancetweaks.limiter.adjustmentmode.AdjustmentMode;

public final class VdtMetrics {
    private final Metrics metrics;

    public VdtMetrics(ViewDistanceTweaks viewDistanceTweaks) {
        this.metrics = new Metrics(viewDistanceTweaks, 6488);
        this.addCustomMetrics(viewDistanceTweaks);
    }

    private void addCustomMetrics(ViewDistanceTweaks viewDistanceTweaks) {
        this.metrics.addCustomChart(new SimplePie("adjustment_mode", () -> viewDistanceTweaks.getVdtConfig().adjustmentMode.get().name()));
        this.metrics.addCustomChart(new SimplePie("reactive_mode_indicator", () -> {
            if (viewDistanceTweaks.getVdtConfig().adjustmentMode.get() != AdjustmentMode.Mode.PROACTIVE) {
                if (PaperTickHook.isCompatible() && viewDistanceTweaks.getVdtConfig().paperSettings.alternativeReactiveModeSettings.useAlternativeSettings.get().booleanValue()) {
                    return "MSPT";
                }
                return "TPS";
            }
            return null;
        }));
    }
}

