/*
 * Decompiled with CFR 0.152.
 */
package com.froobworld.viewdistancetweaks.limiter.adjustmentmode;

import com.froobworld.viewdistancetweaks.hook.viewdistance.SimulationDistanceHook;
import com.froobworld.viewdistancetweaks.limiter.adjustmentmode.AdjustmentMode;
import com.froobworld.viewdistancetweaks.limiter.adjustmentmode.BaseAdjustmentMode;
import com.froobworld.viewdistancetweaks.util.ChunkCounter;
import com.froobworld.viewdistancetweaks.util.TpsTracker;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import java.util.function.Function;
import org.bukkit.World;

public class ReactiveAdjustmentMode
extends BaseAdjustmentMode {
    private final TpsChunkHistory tpsChunkHistory;
    private final SimulationDistanceHook simulationDistanceHook;
    private final TpsTracker tpsTracker;
    private final ChunkCounter chunkCounter;
    private final double increaseTpsThreshold;
    private final double decreaseTpsThreshold;
    private final boolean useTpsChunkHistory;

    public ReactiveAdjustmentMode(TpsTracker tpsTracker, ChunkCounter chunkCounter, double increaseTpsThreshold, double decreaseTpsThreshold, long tpsChunkHistoryLength, boolean useTpsChunkHistory, SimulationDistanceHook simulationDistanceHook, Function<World, Boolean> exclude, Function<World, Integer> maxViewDistance, Function<World, Integer> minViewDistance, int requiredIncrease, int requiredDecrease) {
        super(simulationDistanceHook, exclude, maxViewDistance, minViewDistance, requiredIncrease, requiredDecrease);
        this.tpsTracker = tpsTracker;
        this.simulationDistanceHook = simulationDistanceHook;
        this.chunkCounter = chunkCounter;
        this.increaseTpsThreshold = increaseTpsThreshold;
        this.decreaseTpsThreshold = decreaseTpsThreshold;
        this.tpsChunkHistory = new TpsChunkHistory(tpsChunkHistoryLength);
        this.useTpsChunkHistory = useTpsChunkHistory;
    }

    @Override
    public Map<World, AdjustmentMode.Adjustment> getAdjustments(Collection<World> worlds) {
        HashMap<World, Integer> chunkCounts = new HashMap<World, Integer>();
        int totalCount = 0;
        for (World world : worlds) {
            totalCount += chunkCounts.computeIfAbsent(world, w -> (int)this.chunkCounter.countChunks((World)w, this.simulationDistanceHook.getDistance(world))).intValue();
        }
        double tps = this.tpsTracker.getTps();
        this.tpsChunkHistory.addRecord(tps, totalCount);
        HashMap<World, AdjustmentMode.Adjustment> adjustments = new HashMap<World, AdjustmentMode.Adjustment>();
        for (World world : worlds) {
            int newChunkCount;
            int oldChunkCount;
            AdjustmentMode.Adjustment adjustment;
            if (tps >= this.increaseTpsThreshold) {
                if (this.useTpsChunkHistory && this.tpsChunkHistory.getLowestTps(totalCount) <= this.decreaseTpsThreshold) {
                    adjustments.put(world, this.tryStay(world));
                    continue;
                }
                adjustment = this.tryIncrease(world);
                adjustments.put(world, adjustment);
                if (adjustment != AdjustmentMode.Adjustment.INCREASE) continue;
                oldChunkCount = (Integer)chunkCounts.get(world);
                newChunkCount = (int)this.chunkCounter.countChunks(world, this.simulationDistanceHook.getDistance(world) + 1);
                totalCount += newChunkCount - oldChunkCount;
                continue;
            }
            if (tps <= this.decreaseTpsThreshold) {
                adjustment = this.tryDecrease(world);
                adjustments.put(world, adjustment);
                if (adjustment != AdjustmentMode.Adjustment.DECREASE) continue;
                oldChunkCount = (Integer)chunkCounts.get(world);
                newChunkCount = (int)this.chunkCounter.countChunks(world, this.simulationDistanceHook.getDistance(world) - 1);
                totalCount += newChunkCount - oldChunkCount;
                continue;
            }
            adjustments.put(world, AdjustmentMode.Adjustment.STAY);
        }
        this.tpsChunkHistory.purge();
        return adjustments;
    }

    private static class TpsChunkHistory {
        private final long historyLengthMillis;
        private final Map<Long, TpsChunkRecord> records = new HashMap<Long, TpsChunkRecord>();

        public TpsChunkHistory(long historyLength) {
            this.historyLengthMillis = TimeUnit.MINUTES.toMillis(historyLength);
        }

        public double getLowestTps(int chunkCount) {
            double curMin = 20.0;
            for (TpsChunkRecord record : this.records.values()) {
                if (record.chunkCount > chunkCount) continue;
                curMin = Math.min(curMin, record.tps);
            }
            return curMin;
        }

        public void addRecord(double tps, int chunkCount) {
            this.records.put(System.currentTimeMillis(), new TpsChunkRecord(tps, chunkCount));
        }

        public void purge() {
            long curTimeMillis = System.currentTimeMillis();
            this.records.entrySet().removeIf(entry -> curTimeMillis - (Long)entry.getKey() > this.historyLengthMillis);
        }

        private static class TpsChunkRecord {
            public final double tps;
            public final int chunkCount;

            public TpsChunkRecord(double tps, int chunkCount) {
                this.tps = tps;
                this.chunkCount = chunkCount;
            }
        }
    }
}

