/*
 * Decompiled with CFR 0.152.
 */
package com.froobworld.viewdistancetweaks.limiter.adjustmentmode;

import com.froobworld.viewdistancetweaks.hook.viewdistance.SimulationDistanceHook;
import com.froobworld.viewdistancetweaks.limiter.adjustmentmode.AdjustmentMode;
import com.froobworld.viewdistancetweaks.limiter.adjustmentmode.BaseAdjustmentMode;
import com.froobworld.viewdistancetweaks.util.ChunkCounter;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import java.util.function.Function;
import org.bukkit.World;

public class ProactiveAdjustmentMode
extends BaseAdjustmentMode {
    private final int globalChunkCountTarget;
    private final SimulationDistanceHook simulationDistanceHook;
    private final ChunkCounter chunkCounter;

    public ProactiveAdjustmentMode(int globalChunkCountTarget, SimulationDistanceHook simulationDistanceHook, ChunkCounter chunkCounter, Function<World, Boolean> exclude, Function<World, Integer> maxViewDistance, Function<World, Integer> minViewDistance, int requiredForIncrease, int requiredForDecrease) {
        super(simulationDistanceHook, exclude, maxViewDistance, minViewDistance, requiredForIncrease, requiredForDecrease);
        this.globalChunkCountTarget = globalChunkCountTarget;
        this.simulationDistanceHook = simulationDistanceHook;
        this.chunkCounter = chunkCounter;
    }

    @Override
    public Map<World, AdjustmentMode.Adjustment> getAdjustments(Collection<World> worlds) {
        HashMap<World, Integer> chunkCounts = new HashMap<World, Integer>();
        int totalCount = 0;
        for (World world : worlds) {
            totalCount += chunkCounts.computeIfAbsent(world, w -> (int)this.chunkCounter.countChunks((World)w, this.simulationDistanceHook.getDistance(world))).intValue();
        }
        HashMap<World, AdjustmentMode.Adjustment> adjustments = new HashMap<World, AdjustmentMode.Adjustment>();
        for (World world : worlds) {
            int chunkCountDiff = 0;
            if (totalCount < this.globalChunkCountTarget) {
                int newChunkCount = (int)this.chunkCounter.countChunks(world, this.simulationDistanceHook.getDistance(world) + 1);
                int oldCount = (Integer)chunkCounts.get(world);
                AdjustmentMode.Adjustment adjustment = this.tryIncrease(world);
                if (totalCount + newChunkCount - oldCount <= this.globalChunkCountTarget) {
                    adjustments.put(world, adjustment);
                    if (adjustment == AdjustmentMode.Adjustment.INCREASE) {
                        chunkCountDiff = newChunkCount - oldCount;
                    }
                } else {
                    adjustments.put(world, AdjustmentMode.Adjustment.STAY);
                }
            } else if (totalCount > this.globalChunkCountTarget) {
                AdjustmentMode.Adjustment adjustment = this.tryDecrease(world);
                adjustments.put(world, adjustment);
                if (adjustment == AdjustmentMode.Adjustment.DECREASE) {
                    int newChunkCount = (int)this.chunkCounter.countChunks(world, this.simulationDistanceHook.getDistance(world) - 1);
                    int oldCount = (Integer)chunkCounts.get(world);
                    chunkCountDiff = newChunkCount - oldCount;
                }
            } else {
                AdjustmentMode.Adjustment adjustment = this.tryStay(world);
                adjustments.put(world, adjustment);
            }
            totalCount += chunkCountDiff;
        }
        return adjustments;
    }
}

