/*
 * Decompiled with CFR 0.152.
 */
package com.froobworld.viewdistancetweaks.limiter.adjustmentmode;

import com.froobworld.viewdistancetweaks.hook.viewdistance.SimulationDistanceHook;
import com.froobworld.viewdistancetweaks.limiter.adjustmentmode.AdjustmentMode;
import java.util.HashMap;
import java.util.Map;
import java.util.UUID;
import java.util.function.Function;
import org.bukkit.World;

public abstract class BaseAdjustmentMode
implements AdjustmentMode {
    private final Map<UUID, AdjustmentHistory> worldAdjustmentHistory = new HashMap<UUID, AdjustmentHistory>();
    private final SimulationDistanceHook simulationDistanceHook;
    private final Function<World, Boolean> exclude;
    private final Function<World, Integer> maximumViewDistance;
    private final Function<World, Integer> minimumViewDistance;
    private final int requiredIncrease;
    private final int requiredDecrease;

    public BaseAdjustmentMode(SimulationDistanceHook simulationDistanceHook, Function<World, Boolean> exclude, Function<World, Integer> maximumViewDistance, Function<World, Integer> minimumViewDistance, int requiredIncrease, int requiredDecrease) {
        this.simulationDistanceHook = simulationDistanceHook;
        this.exclude = exclude;
        this.maximumViewDistance = maximumViewDistance;
        this.minimumViewDistance = minimumViewDistance;
        this.requiredIncrease = requiredIncrease;
        this.requiredDecrease = requiredDecrease;
    }

    public AdjustmentMode.Adjustment tryIncrease(World world) {
        if (this.exclude.apply(world).booleanValue()) {
            return AdjustmentMode.Adjustment.STAY;
        }
        return this.getAdjustmentHistory(world).increase() < this.requiredIncrease ? AdjustmentMode.Adjustment.STAY : (this.simulationDistanceHook.getDistance(world) < this.maximumViewDistance.apply(world) ? AdjustmentMode.Adjustment.INCREASE : AdjustmentMode.Adjustment.STAY);
    }

    public AdjustmentMode.Adjustment tryDecrease(World world) {
        if (this.exclude.apply(world).booleanValue()) {
            return AdjustmentMode.Adjustment.STAY;
        }
        return this.getAdjustmentHistory(world).decrease() < this.requiredDecrease ? AdjustmentMode.Adjustment.STAY : (this.simulationDistanceHook.getDistance(world) > this.minimumViewDistance.apply(world) ? AdjustmentMode.Adjustment.DECREASE : AdjustmentMode.Adjustment.STAY);
    }

    public AdjustmentMode.Adjustment tryStay(World world) {
        this.getAdjustmentHistory(world).stay();
        return AdjustmentMode.Adjustment.STAY;
    }

    private AdjustmentHistory getAdjustmentHistory(World world) {
        return this.worldAdjustmentHistory.computeIfAbsent(world.getUID(), uuid -> new AdjustmentHistory());
    }

    private static class AdjustmentHistory {
        private int increaseCount;
        private int decreaseCount;

        private AdjustmentHistory() {
        }

        public int increase() {
            ++this.increaseCount;
            this.decreaseCount = 0;
            return this.increaseCount;
        }

        public int decrease() {
            ++this.decreaseCount;
            this.increaseCount = 0;
            return this.decreaseCount;
        }

        public void stay() {
            this.increaseCount = 0;
            this.decreaseCount = 0;
        }
    }
}

