/*
 * Decompiled with CFR 0.152.
 */
package com.froobworld.viewdistancetweaks.limiter.adjustmentmode;

import com.froobworld.viewdistancetweaks.hook.viewdistance.SimulationDistanceHook;
import com.froobworld.viewdistancetweaks.limiter.adjustmentmode.AdjustmentMode;
import com.froobworld.viewdistancetweaks.limiter.adjustmentmode.BaseAdjustmentMode;
import com.froobworld.viewdistancetweaks.util.ChunkCounter;
import com.froobworld.viewdistancetweaks.util.MsptTracker;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import java.util.function.Function;
import org.bukkit.World;

public class AlternativeReactiveAdjustmentMode
extends BaseAdjustmentMode {
    private final MsptChunkHistory msptChunkHistory;
    private final SimulationDistanceHook simulationDistanceHook;
    private final MsptTracker msptTracker;
    private final ChunkCounter chunkCounter;
    private final double increaseMsptThreshold;
    private final double decreaseMsptThreshold;
    private final boolean useMsptChunkHistory;

    public AlternativeReactiveAdjustmentMode(MsptTracker msptTracker, ChunkCounter chunkCounter, double increaseMsptThreshold, double decreaseMsptThreshold, long msptChunkHistoryLength, boolean useMsptChunkHistory, SimulationDistanceHook simulationDistanceHook, Function<World, Boolean> exclude, Function<World, Integer> maxViewDistance, Function<World, Integer> minViewDistance, int requiredIncrease, int requiredDecrease) {
        super(simulationDistanceHook, exclude, maxViewDistance, minViewDistance, requiredIncrease, requiredDecrease);
        this.msptTracker = msptTracker;
        this.simulationDistanceHook = simulationDistanceHook;
        this.chunkCounter = chunkCounter;
        this.increaseMsptThreshold = increaseMsptThreshold;
        this.decreaseMsptThreshold = decreaseMsptThreshold;
        this.msptChunkHistory = new MsptChunkHistory(msptChunkHistoryLength);
        this.useMsptChunkHistory = useMsptChunkHistory;
    }

    @Override
    public Map<World, AdjustmentMode.Adjustment> getAdjustments(Collection<World> worlds) {
        HashMap<World, Integer> chunkCounts = new HashMap<World, Integer>();
        int totalCount = 0;
        for (World world : worlds) {
            totalCount += chunkCounts.computeIfAbsent(world, w -> (int)this.chunkCounter.countChunks((World)w, this.simulationDistanceHook.getDistance(world))).intValue();
        }
        double mspt = this.msptTracker.getMspt();
        this.msptChunkHistory.addRecord(mspt, totalCount);
        HashMap<World, AdjustmentMode.Adjustment> adjustments = new HashMap<World, AdjustmentMode.Adjustment>();
        int totalAdditionalChunks = 0;
        for (World world : worlds) {
            if (mspt <= this.increaseMsptThreshold) {
                int additionalChunks = (int)this.chunkCounter.countChunks(world, this.simulationDistanceHook.getDistance(world) + 1) - (Integer)chunkCounts.get(world);
                if (this.useMsptChunkHistory && mspt + this.msptChunkHistory.getMaximumMsptPerChunk() * (double)(totalAdditionalChunks + additionalChunks) >= this.decreaseMsptThreshold) {
                    adjustments.put(world, this.tryStay(world));
                    continue;
                }
                AdjustmentMode.Adjustment adjustment = this.tryIncrease(world);
                adjustments.put(world, adjustment);
                if (adjustment != AdjustmentMode.Adjustment.INCREASE) continue;
                totalAdditionalChunks += additionalChunks;
                continue;
            }
            if (mspt >= this.decreaseMsptThreshold) {
                adjustments.put(world, this.tryDecrease(world));
                continue;
            }
            adjustments.put(world, this.tryStay(world));
        }
        this.msptChunkHistory.purge();
        return adjustments;
    }

    private static class MsptChunkHistory {
        private final long historyLengthMillis;
        private final Map<Long, MsptChunkRecord> records = new HashMap<Long, MsptChunkRecord>();

        public MsptChunkHistory(long historyLength) {
            this.historyLengthMillis = TimeUnit.MINUTES.toMillis(historyLength);
        }

        public double getMaximumMsptPerChunk() {
            double max = 0.0;
            for (MsptChunkRecord record : this.records.values()) {
                max = Math.max(max, record.chunkCount > 0 ? record.mspt / (double)record.chunkCount : 0.0);
            }
            return max;
        }

        public void addRecord(double mspt, int chunkCount) {
            this.records.put(System.currentTimeMillis(), new MsptChunkRecord(mspt, chunkCount));
        }

        public void purge() {
            long curTimeMillis = System.currentTimeMillis();
            this.records.entrySet().removeIf(entry -> curTimeMillis - (Long)entry.getKey() > this.historyLengthMillis);
        }

        private static class MsptChunkRecord {
            public final double mspt;
            public final int chunkCount;

            public MsptChunkRecord(double mspt, int chunkCount) {
                this.mspt = mspt;
                this.chunkCount = chunkCount;
            }
        }
    }
}

