/*
 * Decompiled with CFR 0.152.
 */
package com.froobworld.viewdistancetweaks.limiter;

import com.froobworld.viewdistancetweaks.ViewDistanceTweaks;
import com.froobworld.viewdistancetweaks.hook.viewdistance.SimulationDistanceHook;
import com.froobworld.viewdistancetweaks.limiter.ManualViewDistanceManager;
import com.froobworld.viewdistancetweaks.limiter.ViewDistanceChangeTask;
import com.froobworld.viewdistancetweaks.limiter.adjustmentmode.AdjustmentMode;
import java.text.MessageFormat;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import org.bukkit.Bukkit;
import org.bukkit.World;
import org.bukkit.plugin.Plugin;

public class ViewDistanceLimiter
implements Runnable {
    private final ViewDistanceTweaks viewDistanceTweaks;
    private final SimulationDistanceHook simulationDistanceHook;
    private final AdjustmentMode adjustmentMode;
    private final ManualViewDistanceManager manualViewDistanceManager;
    private final Set<ViewDistanceChangeTask> changeViewDistanceTasks = new HashSet<ViewDistanceChangeTask>();
    private final boolean logChanges;
    private final String logFormat;
    private Integer taskId;

    public ViewDistanceLimiter(ViewDistanceTweaks viewDistanceTweaks, SimulationDistanceHook simulationDistanceHook, AdjustmentMode adjustmentMode, ManualViewDistanceManager manualViewDistanceManager, boolean logChanges, String logFormat) {
        this.viewDistanceTweaks = viewDistanceTweaks;
        this.simulationDistanceHook = simulationDistanceHook;
        this.adjustmentMode = adjustmentMode;
        this.manualViewDistanceManager = manualViewDistanceManager;
        this.logChanges = logChanges;
        this.logFormat = logFormat;
    }

    @Override
    public void run() {
        if (this.changeViewDistanceTasks.isEmpty()) {
            List<World> nonEmptyWorlds = Bukkit.getWorlds().stream().filter(world -> !world.getPlayers().isEmpty()).filter(world -> !this.manualViewDistanceManager.hasManuallySetViewDistance((World)world)).collect(Collectors.toList());
            Map adjustments = nonEmptyWorlds.isEmpty() ? Collections.emptyMap() : this.adjustmentMode.getAdjustments(nonEmptyWorlds);
            for (Map.Entry entry : adjustments.entrySet()) {
                World world2 = (World)entry.getKey();
                AdjustmentMode.Adjustment adjustment = (AdjustmentMode.Adjustment)((Object)entry.getValue());
                int oldViewDistance = this.simulationDistanceHook.getDistance(world2);
                if (adjustment == AdjustmentMode.Adjustment.STAY) continue;
                int newViewDistance = oldViewDistance + (adjustment == AdjustmentMode.Adjustment.INCREASE ? 1 : -1);
                ViewDistanceChangeTask changeTask = new ViewDistanceChangeTask(this.viewDistanceTweaks, this.simulationDistanceHook, world2, newViewDistance, 0L);
                changeTask.run();
                this.changeViewDistanceTasks.add(changeTask);
                if (!this.logChanges) continue;
                this.viewDistanceTweaks.getLogger().info(MessageFormat.format(this.logFormat, world2.getName(), oldViewDistance, newViewDistance));
            }
        }
        this.changeViewDistanceTasks.removeIf(ViewDistanceChangeTask::completed);
    }

    public void start(long period, long startUpDelay) {
        if (this.taskId != null) {
            throw new IllegalStateException("Already started.");
        }
        this.taskId = Bukkit.getScheduler().scheduleSyncRepeatingTask((Plugin)this.viewDistanceTweaks, (Runnable)this, startUpDelay + period, period);
    }

    public void cancel() {
        if (this.taskId != null) {
            Bukkit.getScheduler().cancelTask(this.taskId.intValue());
            this.changeViewDistanceTasks.forEach(ViewDistanceChangeTask::cancel);
            this.changeViewDistanceTasks.clear();
            this.taskId = null;
        }
    }
}

