/*
 * Decompiled with CFR 0.152.
 */
package com.froobworld.viewdistancetweaks.limiter;

import com.froobworld.viewdistancetweaks.hook.viewdistance.SimulationDistanceHook;
import java.util.Collection;
import java.util.function.Function;
import org.bukkit.World;

public class ViewDistanceClamper {
    private final SimulationDistanceHook simulationDistanceHook;
    private final Function<World, Integer> maxViewDistance;
    private final Function<World, Integer> minViewDistance;

    public ViewDistanceClamper(SimulationDistanceHook simulationDistanceHook, Function<World, Integer> maxViewDistance, Function<World, Integer> minViewDistance) {
        this.simulationDistanceHook = simulationDistanceHook;
        this.maxViewDistance = maxViewDistance;
        this.minViewDistance = minViewDistance;
    }

    public void clampWorld(World world) {
        int viewDistance = this.simulationDistanceHook.getDistance(world);
        int newViewDistance = Math.max(Math.min(viewDistance, this.maxViewDistance.apply(world)), this.minViewDistance.apply(world));
        if (newViewDistance != viewDistance) {
            this.simulationDistanceHook.setDistance(world, newViewDistance);
        }
    }

    public void clampWorlds(Collection<World> worlds) {
        for (World world : worlds) {
            this.clampWorld(world);
        }
    }
}

