/*
 * Decompiled with CFR 0.152.
 */
package com.froobworld.viewdistancetweaks.limiter;

import com.froobworld.viewdistancetweaks.ViewDistanceTweaks;
import com.froobworld.viewdistancetweaks.hook.viewdistance.SimulationDistanceHook;
import org.bukkit.Bukkit;
import org.bukkit.World;
import org.bukkit.plugin.Plugin;

public class ViewDistanceChangeTask
implements Runnable {
    private ViewDistanceTweaks viewDistanceTweaks;
    private SimulationDistanceHook simulationDistanceHook;
    private Integer currentTaskId;
    private World world;
    private int newViewDistance;
    private long changePeriod;
    private boolean completed = false;

    public ViewDistanceChangeTask(ViewDistanceTweaks viewDistanceTweaks, SimulationDistanceHook simulationDistanceHook, World world, int newViewDistance, long changePeriod) {
        this.viewDistanceTweaks = viewDistanceTweaks;
        this.simulationDistanceHook = simulationDistanceHook;
        this.world = world;
        this.newViewDistance = newViewDistance;
        this.changePeriod = changePeriod;
    }

    @Override
    public void run() {
        if (this.changePeriod <= 0L) {
            this.simulationDistanceHook.setDistance(this.world, this.newViewDistance);
            this.completed = true;
        } else {
            int currentViewDistance = this.simulationDistanceHook.getDistance(this.world);
            int diff = Integer.compare(this.newViewDistance, currentViewDistance);
            this.simulationDistanceHook.setDistance(this.world, currentViewDistance + diff);
            if (currentViewDistance + diff != this.newViewDistance) {
                this.currentTaskId = Bukkit.getScheduler().scheduleSyncDelayedTask((Plugin)this.viewDistanceTweaks, (Runnable)this, this.changePeriod);
            } else {
                this.completed = true;
            }
        }
    }

    public void cancel() {
        if (this.currentTaskId != null) {
            Bukkit.getScheduler().cancelTask(this.currentTaskId.intValue());
        }
    }

    public boolean completed() {
        return this.completed;
    }
}

