/*
 * Decompiled with CFR 0.152.
 */
package com.froobworld.viewdistancetweaks.limiter;

import com.froobworld.viewdistancetweaks.ViewDistanceTweaks;
import com.froobworld.viewdistancetweaks.hook.viewdistance.SimulationDistanceHook;
import java.util.HashMap;
import java.util.Map;
import java.util.UUID;
import org.bukkit.Bukkit;
import org.bukkit.World;
import org.bukkit.plugin.Plugin;

public class ManualViewDistanceManager {
    private final ViewDistanceTweaks viewDistanceTweaks;
    private final Map<UUID, Integer> worldTaskMap = new HashMap<UUID, Integer>();
    private final Map<UUID, Integer> previousViewDistance = new HashMap<UUID, Integer>();
    private final SimulationDistanceHook simulationDistanceHook;

    public ManualViewDistanceManager(ViewDistanceTweaks viewDistanceTweaks, SimulationDistanceHook simulationDistanceHook) {
        this.viewDistanceTweaks = viewDistanceTweaks;
        this.simulationDistanceHook = simulationDistanceHook;
    }

    public void setViewDistance(World world, int viewDistance, long durationTicks) {
        if (durationTicks <= 0L) {
            throw new IllegalArgumentException("Duration must be positive.");
        }
        if (!this.previousViewDistance.containsKey(world.getUID())) {
            this.previousViewDistance.put(world.getUID(), this.simulationDistanceHook.getDistance(world));
        }
        this.simulationDistanceHook.setDistance(world, viewDistance);
        Integer lastTaskId = this.worldTaskMap.remove(world.getUID());
        if (lastTaskId != null) {
            Bukkit.getScheduler().cancelTask(lastTaskId.intValue());
        }
        this.worldTaskMap.put(world.getUID(), Bukkit.getScheduler().scheduleSyncDelayedTask((Plugin)this.viewDistanceTweaks, () -> {
            this.simulationDistanceHook.setDistance(world, this.previousViewDistance.remove(world.getUID()));
            this.worldTaskMap.remove(world.getUID());
        }, durationTicks));
    }

    public boolean hasManuallySetViewDistance(World world) {
        return this.worldTaskMap.containsKey(world.getUID());
    }

    public void cancel() {
        for (int taskId : this.worldTaskMap.values()) {
            Bukkit.getScheduler().cancelTask(taskId);
        }
        for (World world : Bukkit.getWorlds()) {
            if (!this.previousViewDistance.containsKey(world.getUID())) continue;
            this.simulationDistanceHook.setDistance(world, this.previousViewDistance.get(world.getUID()));
        }
        this.worldTaskMap.clear();
    }
}

