/*
 * Decompiled with CFR 0.152.
 */
package com.froobworld.viewdistancetweaks.limiter;

import com.froobworld.viewdistancetweaks.ViewDistanceTweaks;
import com.froobworld.viewdistancetweaks.lib.joor.Reflect;
import com.froobworld.viewdistancetweaks.util.NmsUtils;
import org.bukkit.Bukkit;
import org.bukkit.World;
import org.bukkit.entity.Player;
import org.bukkit.event.EventHandler;
import org.bukkit.event.Listener;
import org.bukkit.event.player.PlayerChangedWorldEvent;
import org.bukkit.event.player.PlayerJoinEvent;
import org.bukkit.plugin.Plugin;

public class ClientViewDistanceManager
implements Listener {
    private final ViewDistanceTweaks viewDistanceTweaks;

    public ClientViewDistanceManager(ViewDistanceTweaks viewDistanceTweaks) {
        this.viewDistanceTweaks = viewDistanceTweaks;
        if (NmsUtils.getMajorVersion() >= 1 && NmsUtils.getMinorVersion() >= 18) {
            Bukkit.getOnlinePlayers().forEach(this::sendOptimisticViewDistance);
            Bukkit.getPluginManager().registerEvents((Listener)this, (Plugin)viewDistanceTweaks);
        }
    }

    public void preViewDistanceChange(World world, int newViewDistance) {
        int maxWorldViewDistance = this.viewDistanceTweaks.getVdtConfig().worldSettings.of((World)world).viewDistance.maximumViewDistance.get();
        world.getPlayers().forEach(player -> this.sendViewDistance((Player)player, Math.max(maxWorldViewDistance, newViewDistance)));
    }

    private int getOptimisticViewDistance(World world) {
        int worldViewDistance = world.getViewDistance();
        int maxWorldViewDistance = this.viewDistanceTweaks.getVdtConfig().worldSettings.of((World)world).viewDistance.maximumViewDistance.get();
        return Math.max(worldViewDistance, maxWorldViewDistance);
    }

    private void sendOptimisticViewDistance(Player player) {
        this.sendViewDistance(player, this.getOptimisticViewDistance(player.getWorld()));
    }

    private void sendViewDistance(Player player, int viewDistance) {
        Object packet = Reflect.onClass("net.minecraft.network.protocol.game.PacketPlayOutViewDistance").create(player.getWorld().getViewDistance()).create(viewDistance).get();
        Reflect.on(player).call("getHandle").field("b").call("a", packet);
    }

    @EventHandler
    private void onPlayerChangeWorld(PlayerChangedWorldEvent event) {
        this.sendOptimisticViewDistance(event.getPlayer());
    }

    @EventHandler
    private void onPlayerJoin(PlayerJoinEvent event) {
        this.sendOptimisticViewDistance(event.getPlayer());
    }
}

