/*
 * Decompiled with CFR 0.152.
 */
package com.froobworld.viewdistancetweaks.lib.nabconfiguration.utils;

import com.froobworld.viewdistancetweaks.lib.nabconfiguration.patcher.structure.YamlElement;
import com.froobworld.viewdistancetweaks.lib.nabconfiguration.patcher.structure.YamlField;
import com.froobworld.viewdistancetweaks.lib.nabconfiguration.patcher.structure.YamlFile;
import com.froobworld.viewdistancetweaks.lib.nabconfiguration.patcher.structure.YamlGibberish;
import com.froobworld.viewdistancetweaks.lib.nabconfiguration.patcher.structure.YamlSection;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.regex.Pattern;
import java.util.stream.Collectors;

public final class YamlUtils {
    private YamlUtils() {
    }

    public static boolean isComment(String line) {
        return line.trim().startsWith("#");
    }

    public static List<String> elementsToBody(List<YamlElement> elements, int indentLevel) {
        ArrayList<String> lines = new ArrayList<String>();
        Iterator<YamlElement> iterator = elements.iterator();
        while (iterator.hasNext()) {
            YamlElement element = iterator.next();
            lines.addAll(element.toLines());
            if (!iterator.hasNext()) continue;
            lines.add("");
        }
        return lines.stream().map(string -> (string.isEmpty() ? "" : String.join((CharSequence)"", Collections.nCopies(indentLevel, " "))) + string).collect(Collectors.toList());
    }

    public static YamlGibberish commentOut(YamlElement element) {
        List<String> lines = element.toLines();
        return new YamlGibberish(lines.stream().map(line -> YamlUtils.isComment(line) ? line : "#" + line).collect(Collectors.toList()));
    }

    public static List<WildcardString> getMatchingKeys(String keyPattern, YamlFile yamlFile) {
        ArrayList<WildcardString> keys = new ArrayList<WildcardString>();
        block0: for (String key : YamlUtils.getAllKeys(yamlFile.getElements())) {
            String[] keyPatternSplit;
            String[] keySplit = key.split(Pattern.quote("."));
            if (keySplit.length != (keyPatternSplit = keyPattern.split(Pattern.quote("."))).length) continue;
            ArrayList<String> wildcardMatches = new ArrayList<String>();
            for (int i = 0; i < keySplit.length; ++i) {
                if (keyPatternSplit[i].equalsIgnoreCase("*")) {
                    wildcardMatches.add(keySplit[i]);
                } else if (!keySplit[i].equals(keyPatternSplit[i])) continue block0;
                if (i != keySplit.length - 1) continue;
                keys.add(new WildcardString(key, wildcardMatches));
            }
        }
        return keys;
    }

    private static List<String> getAllKeys(List<YamlElement> elements) {
        ArrayList<String> keys = new ArrayList<String>();
        for (YamlElement element : elements) {
            if (element instanceof YamlSection) {
                keys.add(((YamlSection)element).getKey());
                keys.addAll(YamlUtils.getAllKeys(((YamlSection)element).elements()).stream().map(key -> ((YamlSection)element).getKey() + "." + key).collect(Collectors.toSet()));
            }
            if (!(element instanceof YamlField)) continue;
            keys.add(((YamlField)element).getKey());
        }
        return keys;
    }

    public static class WildcardString {
        public final String string;
        public final List<String> wildcardMatches;

        public WildcardString(String string, List<String> wildcardMatches) {
            this.string = string;
            this.wildcardMatches = wildcardMatches;
        }
    }
}

