/*
 * Decompiled with CFR 0.152.
 */
package com.froobworld.viewdistancetweaks.lib.nabconfiguration.utils;

import com.google.common.collect.Sets;
import java.util.Collections;
import java.util.Set;
import org.bukkit.configuration.ConfigurationSection;

public class InstantFallbackConfigurationSection {
    private final ConfigurationSection baseSection;
    private InstantFallbackConfigurationSection fallbackSection;

    public InstantFallbackConfigurationSection(ConfigurationSection baseSection) {
        this(baseSection, null);
    }

    private InstantFallbackConfigurationSection(ConfigurationSection baseSection, InstantFallbackConfigurationSection fallbackSection) {
        this.baseSection = baseSection;
        this.fallbackSection = fallbackSection;
    }

    public Object get(String key) {
        return this.baseSection.get(key, this.fallbackSection == null ? null : this.fallbackSection.get(key));
    }

    public Set<String> getKeys(boolean deep) {
        return Sets.union((Set)this.baseSection.getKeys(deep), this.fallbackSection == null ? Collections.emptySet() : this.fallbackSection.getKeys(deep));
    }

    public InstantFallbackConfigurationSection getSection(String key, String defaultKey) {
        InstantFallbackConfigurationSection fallbackSectionTail;
        ConfigurationSection newBaseSection = this.baseSection.getConfigurationSection(key);
        ConfigurationSection newFirstFallbackSection = defaultKey == null ? null : this.baseSection.getConfigurationSection(defaultKey);
        InstantFallbackConfigurationSection instantFallbackConfigurationSection = fallbackSectionTail = this.fallbackSection == null ? null : this.fallbackSection.getSection(key, defaultKey);
        if (newBaseSection == null && newFirstFallbackSection == null) {
            return this.fallbackSection.getSection(key, defaultKey);
        }
        if (newBaseSection == null) {
            return new InstantFallbackConfigurationSection(newFirstFallbackSection, fallbackSectionTail);
        }
        if (newFirstFallbackSection == null) {
            return new InstantFallbackConfigurationSection(newBaseSection, fallbackSectionTail);
        }
        return new InstantFallbackConfigurationSection(newBaseSection, new InstantFallbackConfigurationSection(newFirstFallbackSection, fallbackSectionTail));
    }

    public ConfigurationSection getBaseSection() {
        return this.baseSection;
    }
}

