/*
 * Decompiled with CFR 0.152.
 */
package com.froobworld.viewdistancetweaks.lib.nabconfiguration.patcher.structure.parser;

import com.froobworld.viewdistancetweaks.lib.nabconfiguration.patcher.structure.YamlElement;
import com.froobworld.viewdistancetweaks.lib.nabconfiguration.patcher.structure.YamlField;
import com.froobworld.viewdistancetweaks.lib.nabconfiguration.patcher.structure.YamlFile;
import com.froobworld.viewdistancetweaks.lib.nabconfiguration.patcher.structure.YamlGibberish;
import com.froobworld.viewdistancetweaks.lib.nabconfiguration.patcher.structure.YamlSection;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.ListIterator;
import java.util.Map;
import java.util.Set;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import org.yaml.snakeyaml.Yaml;

public class YamlFileParser {
    private static final Yaml YAML = new Yaml();
    private static final String COMMENT_REGEX = "(#[^\r\n|\r|\n]{0,200}(\r\n|\r|\n))";
    private static final String KEY_REGEX = "((?<=\\r\\n|\\r|\\n)[a-zA-Z0-9-_][a-zA-Z0-9-_ ]*:)";
    private static final Pattern YAML_ENTRY_SEPARATOR_PATTERN = Pattern.compile("(?=(?<!(#[^\r\n|\r|\n]{0,200}(\r\n|\r|\n)))(#[^\r\n|\r|\n]{0,200}(\r\n|\r|\n))*((?<=\\r\\n|\\r|\\n)[a-zA-Z0-9-_][a-zA-Z0-9-_ ]*:))");
    private static final String KEY_LINE_REGEX = "[a-zA-Z0-9-_][a-zA-Z0-9-_ ]*:.*";
    private static final String COMMENT_LINE_REGEX = "#.*";

    public static YamlFile parse(File file) throws IOException {
        return new YamlFile(YamlFileParser.parse(new BufferedReader(new FileReader(file)).lines().collect(Collectors.joining("\n"))));
    }

    private static List<YamlElement> parse(String input) throws IOException {
        Map yamlMap = (Map)YAML.load(input);
        if (yamlMap == null) {
            return new ArrayList<YamlElement>();
        }
        Set sectionKeys = yamlMap.entrySet().stream().filter(entry -> entry.getValue() == null || entry.getValue() instanceof Map).map(Map.Entry::getKey).collect(Collectors.toSet());
        ArrayList<YamlElement> elementList = new ArrayList<YamlElement>();
        for (String entry2 : YAML_ENTRY_SEPARATOR_PATTERN.split(input)) {
            ElementGibberishPairBuilder builder = new ElementGibberishPairBuilder();
            for (String line : entry2.split("\n", -1)) {
                if (line.trim().isEmpty()) {
                    builder.empty();
                    continue;
                }
                if (line.matches(KEY_LINE_REGEX)) {
                    String[] keyValueArray = line.split(":", 2);
                    builder.key(keyValueArray[0], keyValueArray[1], sectionKeys.contains(keyValueArray[0]));
                    continue;
                }
                if (line.matches(" *#.*")) {
                    builder.comment(line);
                    continue;
                }
                builder.other(line);
            }
            ElementGibberishPair pair = builder.build();
            if (pair.element != null) {
                elementList.add(pair.element);
            }
            if (pair.gibberish == null) continue;
            elementList.add(pair.gibberish);
        }
        return elementList;
    }

    private static class ElementGibberishPair {
        public final YamlElement element;
        public final YamlGibberish gibberish;

        private ElementGibberishPair(YamlElement element, YamlGibberish gibberish) {
            this.element = element;
            this.gibberish = gibberish;
        }
    }

    private static class ElementGibberishPairBuilder {
        private boolean section;
        private Integer sectionIndentation;
        private List<String> comment = new ArrayList<String>();
        private String key;
        private String value;
        private List<String> body = new ArrayList<String>();
        private List<String> tail = new ArrayList<String>();

        public ElementGibberishPairBuilder key(String key, String value, boolean section) {
            this.key = key;
            this.value = value;
            this.section = section;
            return this;
        }

        public ElementGibberishPairBuilder comment(String line) {
            if (this.key == null) {
                this.comment.add(line);
            } else {
                this.tail.add(line);
            }
            return this;
        }

        public ElementGibberishPairBuilder other(String line) {
            if (this.key == null) {
                throw new IllegalArgumentException("Can't accept non-comment value before key has been supplied.");
            }
            this.body.addAll(this.tail);
            this.body.add(line);
            this.tail.clear();
            if (this.section && this.sectionIndentation == null) {
                this.sectionIndentation = 0;
                for (char c : line.toCharArray()) {
                    if (c != ' ') break;
                    Integer n = this.sectionIndentation;
                    Integer n2 = this.sectionIndentation = Integer.valueOf(this.sectionIndentation + 1);
                }
            }
            return this;
        }

        public ElementGibberishPairBuilder empty() {
            if (this.key == null) {
                this.comment.add("");
            } else {
                this.tail.add("");
            }
            return this;
        }

        public ElementGibberishPair build() throws IOException {
            YamlGibberish gibberish;
            ListIterator<String> iterator = this.tail.listIterator();
            while (iterator.hasNext() && iterator.next().isEmpty()) {
                iterator.remove();
            }
            iterator = this.comment.listIterator();
            while (iterator.hasNext() && iterator.next().isEmpty()) {
                iterator.remove();
            }
            iterator = this.tail.listIterator(this.tail.size());
            while (iterator.hasPrevious() && iterator.previous().isEmpty()) {
                iterator.remove();
            }
            iterator = this.comment.listIterator(this.comment.size());
            while (iterator.hasPrevious() && iterator.previous().isEmpty()) {
                iterator.remove();
            }
            YamlElement element = null;
            YamlGibberish yamlGibberish = this.key == null ? (this.comment.isEmpty() ? null : new YamlGibberish(this.comment)) : (gibberish = this.tail.isEmpty() ? null : new YamlGibberish(this.tail));
            if (this.key != null) {
                if (this.section) {
                    String sectionInput = this.body.stream().map(line -> line.replaceFirst(" {0," + this.sectionIndentation + "}", "")).collect(Collectors.joining("\n"));
                    List sectionElements = YamlFileParser.parse(sectionInput);
                    if (sectionElements.isEmpty()) {
                        this.body.addAll(this.tail);
                        gibberish = null;
                        element = new YamlField(this.key, this.comment, this.value, this.body);
                    } else {
                        element = new YamlSection(this.key, this.comment, this.value, YamlFileParser.parse(sectionInput));
                    }
                } else {
                    this.body.addAll(this.tail);
                    gibberish = null;
                    element = new YamlField(this.key, this.comment, this.value, this.body);
                }
            }
            return new ElementGibberishPair(element, gibberish);
        }
    }
}

