/*
 * Decompiled with CFR 0.152.
 */
package com.froobworld.viewdistancetweaks.lib.nabconfiguration.patcher.structure;

import com.froobworld.viewdistancetweaks.lib.nabconfiguration.patcher.structure.YamlElement;
import com.froobworld.viewdistancetweaks.lib.nabconfiguration.patcher.structure.YamlGibberish;
import com.froobworld.viewdistancetweaks.lib.nabconfiguration.utils.YamlUtils;
import java.util.ArrayList;
import java.util.List;

public class YamlFile {
    private List<String> header;
    private List<YamlElement> elements;

    public YamlFile(List<YamlElement> elements) {
        YamlElement firstElement;
        this.elements = elements;
        if (!elements.isEmpty() && (firstElement = elements.get(0)) instanceof YamlGibberish) {
            this.header = firstElement.toLines();
            elements.remove(0);
        }
        if (this.header == null) {
            this.header = new ArrayList<String>();
        }
    }

    public void setHeader(List<String> header) {
        this.header = new ArrayList<String>(header);
    }

    public List<String> toLines() {
        ArrayList<String> lines = new ArrayList<String>();
        if (!this.header.isEmpty()) {
            lines.addAll(this.header);
            lines.add("");
        }
        lines.addAll(YamlUtils.elementsToBody(this.elements, 0));
        return lines;
    }

    public List<YamlElement> getElements() {
        return this.elements;
    }
}

