/*
 * Decompiled with CFR 0.152.
 */
package com.froobworld.viewdistancetweaks.lib.nabconfiguration.patcher.jobs;

import com.froobworld.viewdistancetweaks.lib.nabconfiguration.patcher.jobs.PatchJob;
import com.froobworld.viewdistancetweaks.lib.nabconfiguration.patcher.structure.YamlElement;
import com.froobworld.viewdistancetweaks.lib.nabconfiguration.patcher.structure.YamlField;
import com.froobworld.viewdistancetweaks.lib.nabconfiguration.patcher.structure.YamlFile;
import com.froobworld.viewdistancetweaks.lib.nabconfiguration.patcher.structure.YamlSection;
import com.froobworld.viewdistancetweaks.lib.nabconfiguration.utils.YamlUtils;
import java.util.ArrayList;
import java.util.List;
import java.util.ListIterator;
import java.util.Properties;
import java.util.regex.Pattern;

public class MoveJob
implements PatchJob {
    private String fromKey;
    private String toKey;
    private String before;

    public MoveJob(Properties properties) {
        this.fromKey = properties.getProperty("from");
        this.toKey = properties.getProperty("to");
        this.before = properties.getProperty("before");
    }

    @Override
    public void modify(YamlFile yamlFile) {
        for (YamlUtils.WildcardString matchedKey : YamlUtils.getMatchingKeys(this.fromKey, yamlFile)) {
            boolean found;
            String nextKey;
            int i;
            String[] fromKeySplit = matchedKey.string.split(Pattern.quote("."));
            String toKey = this.toKey;
            String before = this.before;
            for (int i2 = 0; i2 < matchedKey.wildcardMatches.size(); ++i2) {
                toKey = toKey.replace("{" + i2 + "}", matchedKey.wildcardMatches.get(i2));
                before = before == null ? null : before.replace("{" + i2 + "}", matchedKey.wildcardMatches.get(i2));
            }
            String[] toKeySplit = toKey.split(Pattern.quote("."));
            String finalFromKey = fromKeySplit[fromKeySplit.length - 1];
            String finalToKey = toKeySplit[toKeySplit.length - 1];
            List<YamlElement> fromDestination = yamlFile.getElements();
            List<YamlElement> toDestination = yamlFile.getElements();
            for (i = 0; i < fromKeySplit.length - 1; ++i) {
                nextKey = fromKeySplit[i];
                found = false;
                for (YamlElement element : fromDestination) {
                    if (!(element instanceof YamlSection) || !((YamlSection)element).getKey().equals(nextKey)) continue;
                    fromDestination = ((YamlSection)element).elements();
                    found = true;
                    break;
                }
                if (found) continue;
                throw new IllegalStateException();
            }
            for (i = 0; i < toKeySplit.length - 1; ++i) {
                nextKey = toKeySplit[i];
                found = false;
                for (YamlElement element : toDestination) {
                    if (!(element instanceof YamlSection) || !((YamlSection)element).getKey().equals(nextKey)) continue;
                    toDestination = ((YamlSection)element).elements();
                    found = true;
                    break;
                }
                if (found) continue;
                YamlSection newSection = new YamlSection(nextKey, new ArrayList<String>(), "", new ArrayList<YamlElement>());
                toDestination.add(newSection);
                toDestination = newSection.elements();
            }
            YamlElement toMove = null;
            ListIterator<YamlElement> iterator = fromDestination.listIterator();
            while (iterator.hasNext()) {
                YamlElement next = iterator.next();
                if (next instanceof YamlField) {
                    if (!((YamlField)next).getKey().equals(finalFromKey)) continue;
                    toMove = next;
                    iterator.remove();
                    continue;
                }
                if (!(next instanceof YamlSection) || !((YamlSection)next).getKey().equals(finalFromKey)) continue;
                toMove = next;
                iterator.remove();
            }
            if (toMove instanceof YamlField) {
                ((YamlField)toMove).setKey(finalToKey);
            } else if (toMove instanceof YamlSection) {
                ((YamlSection)toMove).setKey(finalToKey);
            }
            if (before == null) {
                toDestination.add(toMove);
                continue;
            }
            int index = 0;
            for (YamlElement element : toDestination) {
                if (element instanceof YamlField ? ((YamlField)element).getKey().equals(before) : element instanceof YamlSection && ((YamlSection)element).getKey().equals(before)) break;
                ++index;
            }
            toDestination.add(index, toMove);
        }
    }
}

