/*
 * Decompiled with CFR 0.152.
 */
package com.froobworld.viewdistancetweaks.lib.nabconfiguration.patcher.jobs;

import com.froobworld.viewdistancetweaks.lib.nabconfiguration.patcher.jobs.PatchJob;
import com.froobworld.viewdistancetweaks.lib.nabconfiguration.patcher.structure.YamlElement;
import com.froobworld.viewdistancetweaks.lib.nabconfiguration.patcher.structure.YamlField;
import com.froobworld.viewdistancetweaks.lib.nabconfiguration.patcher.structure.YamlFile;
import com.froobworld.viewdistancetweaks.lib.nabconfiguration.patcher.structure.YamlSection;
import com.froobworld.viewdistancetweaks.lib.nabconfiguration.utils.YamlUtils;
import java.util.List;
import java.util.ListIterator;
import java.util.Optional;
import java.util.Properties;
import java.util.regex.Pattern;

public class CommentOutJob
implements PatchJob {
    private String key;

    public CommentOutJob(Properties properties) {
        this.key = properties.getProperty("key");
    }

    @Override
    public void modify(YamlFile yamlFile) {
        String[] splitKey = this.key.split(Pattern.quote("."));
        List<YamlElement> elementList = yamlFile.getElements();
        for (int i = 0; i < splitKey.length; ++i) {
            String currentKey = splitKey[i];
            Optional<YamlElement> nextElement = elementList.stream().filter(element -> {
                if (element instanceof YamlField) {
                    return ((YamlField)element).getKey().equals(currentKey);
                }
                if (element instanceof YamlSection) {
                    return ((YamlSection)element).getKey().equals(currentKey);
                }
                return false;
            }).findFirst();
            if (i == splitKey.length - 1) {
                if (nextElement.isPresent()) {
                    ListIterator<YamlElement> iterator = elementList.listIterator();
                    while (iterator.hasNext()) {
                        YamlElement next = iterator.next();
                        if (next instanceof YamlField) {
                            if (!((YamlField)next).getKey().equals(currentKey)) continue;
                            iterator.set(YamlUtils.commentOut(next));
                            continue;
                        }
                        if (!(next instanceof YamlSection) || !((YamlSection)next).getKey().equals(currentKey)) continue;
                        iterator.set(YamlUtils.commentOut(next));
                    }
                    continue;
                }
                throw new IllegalArgumentException("Tried to add comment to element with key " + this.key + ", but element does not exist.");
            }
            if (nextElement.isPresent() && nextElement.get() instanceof YamlSection) {
                elementList = ((YamlSection)nextElement.get()).elements();
                continue;
            }
            throw new IllegalArgumentException("Tried to add comment to element with key " + this.key + ", but a section named " + currentKey + " does not exist.");
        }
    }
}

