/*
 * Decompiled with CFR 0.152.
 */
package com.froobworld.viewdistancetweaks.lib.nabconfiguration.patcher.jobs;

import com.froobworld.viewdistancetweaks.lib.nabconfiguration.patcher.jobs.PatchJob;
import com.froobworld.viewdistancetweaks.lib.nabconfiguration.patcher.structure.YamlElement;
import com.froobworld.viewdistancetweaks.lib.nabconfiguration.patcher.structure.YamlField;
import com.froobworld.viewdistancetweaks.lib.nabconfiguration.patcher.structure.YamlFile;
import com.froobworld.viewdistancetweaks.lib.nabconfiguration.patcher.structure.YamlSection;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Optional;
import java.util.Properties;
import java.util.regex.Pattern;

public class CommentJob
implements PatchJob {
    private String key;
    private List<String> comment;

    public CommentJob(Properties properties) {
        this.key = properties.getProperty("key");
        String commentString = properties.getProperty("comment");
        this.comment = commentString == null ? Collections.emptyList() : Arrays.asList(commentString.split("\n"));
    }

    @Override
    public void modify(YamlFile yamlFile) {
        String[] splitKey = this.key.split(Pattern.quote("."));
        List<YamlElement> elementList = yamlFile.getElements();
        for (int i = 0; i < splitKey.length; ++i) {
            String currentKey = splitKey[i];
            Optional<YamlElement> nextElement = elementList.stream().filter(element -> {
                if (element instanceof YamlField) {
                    return ((YamlField)element).getKey().equals(currentKey);
                }
                if (element instanceof YamlSection) {
                    return ((YamlSection)element).getKey().equals(currentKey);
                }
                return false;
            }).findFirst();
            if (i == splitKey.length - 1) {
                if (nextElement.isPresent()) {
                    if (nextElement.get() instanceof YamlField) {
                        ((YamlField)nextElement.get()).setComment(this.comment);
                        continue;
                    }
                    if (!(nextElement.get() instanceof YamlSection)) continue;
                    ((YamlSection)nextElement.get()).setComment(this.comment);
                    continue;
                }
                throw new IllegalArgumentException("Tried to add comment to element with key " + this.key + ", but element does not exist.");
            }
            if (nextElement.isPresent() && nextElement.get() instanceof YamlSection) {
                elementList = ((YamlSection)nextElement.get()).elements();
                continue;
            }
            throw new IllegalArgumentException("Tried to add comment to element with key " + this.key + ", but a section named " + currentKey + " does not exist.");
        }
    }
}

