/*
 * Decompiled with CFR 0.152.
 */
package com.froobworld.viewdistancetweaks.lib.nabconfiguration.patcher.jobs;

import com.froobworld.viewdistancetweaks.lib.nabconfiguration.patcher.jobs.PatchJob;
import com.froobworld.viewdistancetweaks.lib.nabconfiguration.patcher.structure.YamlElement;
import com.froobworld.viewdistancetweaks.lib.nabconfiguration.patcher.structure.YamlField;
import com.froobworld.viewdistancetweaks.lib.nabconfiguration.patcher.structure.YamlFile;
import com.froobworld.viewdistancetweaks.lib.nabconfiguration.patcher.structure.YamlSection;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Optional;
import java.util.Properties;
import java.util.regex.Pattern;

public class AddFieldJob
implements PatchJob {
    private String key;
    private String value;
    private List<String> comment;
    private List<String> body;
    private String before;

    public AddFieldJob(Properties properties) {
        this.key = properties.getProperty("key");
        String valueString = properties.getProperty("value");
        this.value = valueString == null ? "" : " " + valueString;
        String commentString = properties.getProperty("comment");
        this.comment = commentString == null ? Collections.emptyList() : Arrays.asList(commentString.split("\n"));
        String bodyString = properties.getProperty("body");
        this.body = bodyString == null ? Collections.emptyList() : Arrays.asList(bodyString.split("\n"));
        this.before = properties.getProperty("before");
    }

    @Override
    public void modify(YamlFile yamlFile) {
        String[] splitKey = this.key.split(Pattern.quote("."));
        List<YamlElement> elementList = yamlFile.getElements();
        for (int i = 0; i < splitKey.length; ++i) {
            String currentKey = splitKey[i];
            Optional<YamlElement> nextElement = elementList.stream().filter(element -> {
                if (element instanceof YamlField) {
                    return ((YamlField)element).getKey().equals(currentKey);
                }
                if (element instanceof YamlSection) {
                    return ((YamlSection)element).getKey().equals(currentKey);
                }
                return false;
            }).findFirst();
            if (i == splitKey.length - 1) {
                if (nextElement.isPresent()) {
                    throw new IllegalArgumentException("Tried to add field with key " + this.key + ", but element already exists.");
                }
                YamlField field = new YamlField(currentKey, this.comment, this.value, this.body);
                if (this.before == null) {
                    elementList.add(field);
                    continue;
                }
                int index = 0;
                for (YamlElement element2 : elementList) {
                    if (element2 instanceof YamlField) {
                        if (((YamlField)element2).getKey().equals(this.before)) break;
                        ++index;
                        continue;
                    }
                    if (!(element2 instanceof YamlSection)) continue;
                    if (((YamlSection)element2).getKey().equals(this.before)) break;
                    ++index;
                }
                elementList.add(index, field);
                continue;
            }
            if (nextElement.isPresent() && nextElement.get() instanceof YamlSection) {
                elementList = ((YamlSection)nextElement.get()).elements();
                continue;
            }
            throw new IllegalArgumentException("Tried to add field with key " + this.key + ", but a section named " + currentKey + " does not exist.");
        }
    }
}

