/*
 * Decompiled with CFR 0.152.
 */
package com.froobworld.viewdistancetweaks.lib.nabconfiguration.patcher;

import com.froobworld.viewdistancetweaks.lib.nabconfiguration.patcher.ConfigPatch;
import com.froobworld.viewdistancetweaks.lib.nabconfiguration.patcher.jobs.AddFieldJob;
import com.froobworld.viewdistancetweaks.lib.nabconfiguration.patcher.jobs.AddSectionJob;
import com.froobworld.viewdistancetweaks.lib.nabconfiguration.patcher.jobs.CommentJob;
import com.froobworld.viewdistancetweaks.lib.nabconfiguration.patcher.jobs.CommentOutJob;
import com.froobworld.viewdistancetweaks.lib.nabconfiguration.patcher.jobs.HeaderJob;
import com.froobworld.viewdistancetweaks.lib.nabconfiguration.patcher.jobs.MoveJob;
import com.froobworld.viewdistancetweaks.lib.nabconfiguration.patcher.jobs.PatchJob;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.StringReader;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.Properties;
import java.util.function.Function;
import java.util.regex.Pattern;

public class ConfigPatchLoader {
    private static final Pattern PATCH_HEADER_PATTERN = Pattern.compile("\\[[a-z-]+\\]");
    private static final Map<String, Function<Properties, PatchJob>> PATCH_JOBS = new HashMap<String, Function<Properties, PatchJob>>();

    public static ConfigPatch parse(InputStream inputStream) throws IOException {
        ArrayList<PatchJob> patchJobs = new ArrayList<PatchJob>();
        try (BufferedReader reader = new BufferedReader(new InputStreamReader(inputStream));){
            Function<Properties, PatchJob> currentJobFunction = null;
            StringBuilder currentProperties = new StringBuilder();
            Iterator it = reader.lines().iterator();
            while (it.hasNext()) {
                String line = (String)it.next();
                if (PATCH_HEADER_PATTERN.matcher(line).matches()) {
                    if (currentJobFunction != null) {
                        Properties properties = new Properties();
                        properties.load(new StringReader(currentProperties.toString()));
                        patchJobs.add(currentJobFunction.apply(properties));
                    }
                    currentJobFunction = PATCH_JOBS.get(ConfigPatchLoader.getPatchJobType(line));
                    currentProperties = new StringBuilder();
                    continue;
                }
                currentProperties.append(line).append("\n");
            }
            if (currentJobFunction != null) {
                Properties properties = new Properties();
                properties.load(new StringReader(currentProperties.toString()));
                patchJobs.add(currentJobFunction.apply(properties));
            }
        }
        return new ConfigPatch(patchJobs);
    }

    private static String getPatchJobType(String line) {
        return line.replace("[", "").replace("]", "");
    }

    static {
        PATCH_JOBS.put("add-field", AddFieldJob::new);
        PATCH_JOBS.put("add-section", AddSectionJob::new);
        PATCH_JOBS.put("comment", CommentJob::new);
        PATCH_JOBS.put("comment-out", CommentOutJob::new);
        PATCH_JOBS.put("header", HeaderJob::new);
        PATCH_JOBS.put("move", MoveJob::new);
    }
}

