/*
 * Decompiled with CFR 0.152.
 */
package com.froobworld.viewdistancetweaks.lib.nabconfiguration;

import com.froobworld.viewdistancetweaks.lib.nabconfiguration.ConfigSection;
import com.froobworld.viewdistancetweaks.lib.nabconfiguration.ConfigSectionPopulator;
import com.froobworld.viewdistancetweaks.lib.nabconfiguration.patcher.ConfigPatchLoader;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStream;
import java.io.PrintWriter;
import java.io.Reader;
import java.nio.file.CopyOption;
import java.nio.file.Files;
import java.util.List;
import java.util.Map;
import java.util.function.Function;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import org.yaml.snakeyaml.Yaml;

public class NabConfiguration
extends ConfigSection {
    private final Yaml yaml = new Yaml();
    private final File configFile;
    private final Supplier<InputStream> copyStreamSupplier;
    private final Function<Integer, InputStream> patchStreamSupplier;
    private final int currentVersion;

    public NabConfiguration(File configFile, Supplier<InputStream> copyStreamSupplier, Function<Integer, InputStream> patchStreamSupplier, int currentVersion) {
        this.configFile = configFile;
        this.copyStreamSupplier = copyStreamSupplier;
        this.patchStreamSupplier = patchStreamSupplier;
        this.currentVersion = currentVersion;
    }

    public void load() throws Exception {
        this.init();
        new ConfigSectionPopulator(this.configFile, (ConfigSection)this).populate();
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private void init() throws IOException {
        if (!this.configFile.exists()) {
            this.configFile.getParentFile().mkdirs();
            Files.copy(this.copyStreamSupplier.get(), this.configFile.toPath(), new CopyOption[0]);
        }
        while (true) {
            Throwable throwable;
            int version = -1;
            try {
                throwable = null;
                try (FileReader reader = new FileReader(this.configFile);){
                    version = (Integer)((Map)this.yaml.load((Reader)reader)).get("version");
                }
                catch (Throwable throwable2) {
                    throwable = throwable2;
                    throw throwable2;
                }
            }
            catch (Exception ex) {
                throw new IllegalStateException("Could not find version while initialising " + this.configFile.getName() + ".", ex);
            }
            if (version >= this.currentVersion) return;
            InputStream inputStream = this.patchStreamSupplier.apply(version);
            throwable = null;
            try {
                ConfigPatchLoader.parse(inputStream).patchFile(this.configFile);
                this.updateVersion(version + 1);
                continue;
            }
            catch (Throwable throwable3) {
                throwable = throwable3;
                throw throwable3;
            }
            finally {
                if (inputStream == null) continue;
                if (throwable != null) {
                    try {
                        inputStream.close();
                    }
                    catch (Throwable throwable4) {
                        throwable.addSuppressed(throwable4);
                    }
                    continue;
                }
                inputStream.close();
                continue;
            }
            break;
        }
    }

    private void updateVersion(int newVersion) throws IOException {
        try (BufferedReader reader = new BufferedReader(new FileReader(this.configFile));){
            List lines = reader.lines().map(line -> line.startsWith("version: ") ? "version: " + newVersion : line).collect(Collectors.toList());
            try (PrintWriter writer = new PrintWriter(new FileWriter(this.configFile));){
                for (String line2 : lines) {
                    writer.println(line2);
                }
            }
        }
    }
}

