/*
 * Decompiled with CFR 0.152.
 */
package com.froobworld.viewdistancetweaks.lib.nabconfiguration;

import com.froobworld.viewdistancetweaks.lib.nabconfiguration.ConfigSection;
import java.util.HashMap;
import java.util.Map;
import java.util.function.Function;

public class ConfigSectionMap<K, C extends ConfigSection> {
    private final Function<K, String> keyMappingFunction;
    private final Map<String, C> sectionMap = new HashMap<String, C>();
    private final Class<C> entryType;
    private final boolean ignoreCase;
    private C defaultSection;

    public ConfigSectionMap(Function<K, String> keyMappingFunction, Class<C> entryType, boolean ignoreCase) {
        this.keyMappingFunction = keyMappingFunction;
        this.entryType = entryType;
        this.ignoreCase = ignoreCase;
    }

    void clear() {
        this.sectionMap.clear();
        this.defaultSection = null;
    }

    void setDefaultSection(C defaultSection) {
        this.defaultSection = defaultSection;
    }

    void put(String key, C configSection) {
        key = this.ignoreCase ? key.toLowerCase() : key;
        this.sectionMap.put(key, configSection);
    }

    public C of(K key) {
        String mappedKey = this.keyMappingFunction.apply(key);
        mappedKey = this.ignoreCase ? mappedKey.toLowerCase() : mappedKey;
        return (C)((ConfigSection)this.sectionMap.getOrDefault(mappedKey, this.defaultSection));
    }

    Class<C> entryType() {
        return this.entryType;
    }
}

