/*
 * Decompiled with CFR 0.152.
 */
package com.froobworld.viewdistancetweaks.lib.nabconfiguration;

import com.froobworld.viewdistancetweaks.lib.nabconfiguration.ConfigEntry;
import java.util.HashMap;
import java.util.Map;
import java.util.function.Function;
import java.util.function.Supplier;

public class ConfigEntryMap<K, T> {
    private final Function<K, String> keyMappingFunction;
    private final Map<String, ConfigEntry<T>> entryMap = new HashMap<String, ConfigEntry<T>>();
    private final Supplier<ConfigEntry<T>> emptyConfigEntrySupplier;
    private ConfigEntry<T> def;
    private final boolean ignoreCase;

    public ConfigEntryMap(Function<K, String> keyMappingFunction, Supplier<ConfigEntry<T>> emptyConfigEntrySupplier, boolean ignoreCase) {
        this.keyMappingFunction = keyMappingFunction;
        this.emptyConfigEntrySupplier = emptyConfigEntrySupplier;
        this.def = emptyConfigEntrySupplier.get();
        this.ignoreCase = ignoreCase;
    }

    void clear() {
        this.entryMap.clear();
        this.def = this.emptyConfigEntrySupplier.get();
    }

    public ConfigEntry<T> of(K key) {
        String mappedKey = this.keyMappingFunction.apply(key);
        mappedKey = this.ignoreCase ? mappedKey.toLowerCase() : mappedKey;
        return this.entryMap.getOrDefault(mappedKey, this.def);
    }

    void setDefault(Object def) {
        this.def.setValue(def);
    }

    void put(String key, Object value) {
        key = this.ignoreCase ? key.toLowerCase() : key;
        ConfigEntry<T> configEntry = this.emptyConfigEntrySupplier.get();
        configEntry.setValue(value);
        this.entryMap.put(key, configEntry);
    }
}

