/*
 * Decompiled with CFR 0.152.
 */
package com.froobworld.viewdistancetweaks.hook.viewdistance;

import com.froobworld.viewdistancetweaks.hook.viewdistance.SimulationDistanceHook;
import com.froobworld.viewdistancetweaks.lib.joor.Reflect;
import com.froobworld.viewdistancetweaks.util.NmsUtils;
import com.froobworld.viewdistancetweaks.util.SpigotViewDistanceSyncer;
import com.froobworld.viewdistancetweaks.util.ViewDistanceUtils;
import org.bukkit.World;
import org.bukkit.entity.Player;

public class SpigotSimulationDistanceHook
implements SimulationDistanceHook {
    @Override
    public int getDistance(World world) {
        if (NmsUtils.getMinorVersion() >= 18) {
            return (Integer)Reflect.on(world).call("getSimulationDistance").get();
        }
        return world.getViewDistance();
    }

    @Override
    public void setDistance(World world, int value) {
        if ((value = ViewDistanceUtils.clampViewDistance(value)) != this.getDistance(world)) {
            SpigotSimulationDistanceHook.sendUpdatedSimulationDistance(world, value);
            if (NmsUtils.getMinorVersion() == 18) {
                Reflect.on(world).call("getHandle").call("k").call("b", value);
            } else if (NmsUtils.getMinorVersion() < 18) {
                Reflect.on(world).call("getHandle").call("getChunkProvider").call("setViewDistance", value);
            }
            SpigotViewDistanceSyncer.syncSpigotViewDistances(world);
        }
    }

    private static void sendUpdatedSimulationDistance(World world, int distance) {
        Object packet = NmsUtils.getMinorVersion() < 18 ? Reflect.onClass(NmsUtils.getFullyQualifiedClassName("PacketPlayOutViewDistance", "network.protocol.game")).create(distance).get() : Reflect.onClass(NmsUtils.getFullyQualifiedClassName("ClientboundSetSimulationDistancePacket", "network.protocol.game")).create(distance).get();
        for (Player player : world.getPlayers()) {
            if (NmsUtils.getMinorVersion() == 18) {
                Reflect.on(player).call("getHandle").field("b").call("a", packet);
                continue;
            }
            if (NmsUtils.getMinorVersion() == 17) {
                Reflect.on(player).call("getHandle").field("b").call("sendPacket", packet);
                continue;
            }
            if (NmsUtils.getMinorVersion() >= 17) continue;
            Reflect.on(player).call("getHandle").field("playerConnection").call("sendPacket", packet);
        }
    }

    public static boolean isCompatible() {
        return NmsUtils.getMajorVersion() == 1 && NmsUtils.getMinorVersion() <= 18 && NmsUtils.getRevisionNumber() == 1;
    }
}

