/*
 * Decompiled with CFR 0.152.
 */
package com.froobworld.viewdistancetweaks.hook.viewdistance;

import com.froobworld.viewdistancetweaks.hook.viewdistance.ViewDistanceHook;
import com.froobworld.viewdistancetweaks.util.ViewDistanceUtils;
import org.bukkit.Bukkit;
import org.bukkit.World;

public class PaperViewDistanceHook
implements ViewDistanceHook {
    @Override
    public int getDistance(World world) {
        return world.getNoTickViewDistance();
    }

    @Override
    public void setDistance(World world, int value) {
        if ((value = ViewDistanceUtils.clampViewDistance(value)) != this.getDistance(world)) {
            world.setNoTickViewDistance(value);
        }
    }

    public static boolean isCompatible() {
        try {
            Class.forName("org.bukkit.World").getMethod("setNoTickViewDistance", Integer.TYPE);
        }
        catch (Exception ex) {
            return false;
        }
        try {
            for (World world : Bukkit.getWorlds()) {
                world.setNoTickViewDistance(0);
            }
        }
        catch (IllegalArgumentException e) {
            return true;
        }
        catch (Exception otherException) {
            return false;
        }
        return true;
    }
}

