/*
 * Decompiled with CFR 0.152.
 */
package com.froobworld.viewdistancetweaks.hook.tick;

import com.froobworld.viewdistancetweaks.ViewDistanceTweaks;
import com.froobworld.viewdistancetweaks.hook.tick.TickHook;
import com.froobworld.viewdistancetweaks.lib.joor.Reflect;
import com.froobworld.viewdistancetweaks.util.NmsUtils;
import java.util.HashSet;
import java.util.Set;
import java.util.function.Consumer;
import org.bukkit.Bukkit;
import org.bukkit.plugin.Plugin;

public class SpigotTickHook
implements TickHook {
    private static final Reflect currentTick = Reflect.onClass(NmsUtils.getFullyQualifiedClassName("MinecraftServer", "server")).field("currentTick");
    private final Set<Consumer<Integer>> tickStartCallbacks = new HashSet<Consumer<Integer>>();
    private final Set<Consumer<Integer>> tickEndCallbacks = new HashSet<Consumer<Integer>>();
    private Integer taskId;

    @Override
    public void register(ViewDistanceTweaks viewDistanceTweaks) {
        if (this.taskId == null) {
            this.taskId = Bukkit.getScheduler().scheduleSyncRepeatingTask((Plugin)viewDistanceTweaks, () -> {
                int currentTick = SpigotTickHook.getCurrentTick();
                this.tickEndCallback(currentTick - 1);
                this.tickStartCallback(currentTick);
            }, 0L, 1L);
        }
    }

    @Override
    public boolean addTickStartCallback(Consumer<Integer> consumer) {
        return this.tickStartCallbacks.add(consumer);
    }

    @Override
    public boolean removeTickStartCallback(Consumer<Integer> consumer) {
        return this.tickStartCallbacks.remove(consumer);
    }

    @Override
    public boolean addTickEndCallback(Consumer<Integer> consumer) {
        return this.tickEndCallbacks.add(consumer);
    }

    @Override
    public boolean removeTickEndCallback(Consumer<Integer> consumer) {
        return this.tickEndCallbacks.add(consumer);
    }

    private void tickStartCallback(int tickNumber) {
        this.tickStartCallbacks.forEach(consumer -> consumer.accept(tickNumber));
    }

    private void tickEndCallback(int tickNumber) {
        this.tickEndCallbacks.forEach(consumer -> consumer.accept(tickNumber));
    }

    private static int getCurrentTick() {
        return (Integer)currentTick.get();
    }
}

