/*
 * Decompiled with CFR 0.152.
 */
package com.froobworld.viewdistancetweaks.hook.tick;

import com.destroystokyo.paper.event.server.ServerTickEndEvent;
import com.destroystokyo.paper.event.server.ServerTickStartEvent;
import com.froobworld.viewdistancetweaks.ViewDistanceTweaks;
import com.froobworld.viewdistancetweaks.hook.tick.TickHook;
import java.util.HashSet;
import java.util.Set;
import java.util.function.Consumer;
import org.bukkit.Bukkit;
import org.bukkit.event.EventHandler;
import org.bukkit.event.Listener;
import org.bukkit.plugin.Plugin;

public class PaperTickHook
implements TickHook {
    private final Set<Consumer<Integer>> tickStartCallbacks = new HashSet<Consumer<Integer>>();
    private final Set<Consumer<Integer>> tickEndCallbacks = new HashSet<Consumer<Integer>>();
    private final Listener tickListener = new Listener(){

        @EventHandler
        public void onTickStart(ServerTickStartEvent event) {
            PaperTickHook.this.tickStartCallback(event.getTickNumber());
        }

        @EventHandler
        public void onTickEnd(ServerTickEndEvent event) {
            PaperTickHook.this.tickEndCallback(event.getTickNumber());
        }
    };

    @Override
    public void register(ViewDistanceTweaks viewDistanceTweaks) {
        Bukkit.getPluginManager().registerEvents(this.tickListener, (Plugin)viewDistanceTweaks);
    }

    @Override
    public boolean addTickStartCallback(Consumer<Integer> consumer) {
        return this.tickStartCallbacks.add(consumer);
    }

    @Override
    public boolean removeTickStartCallback(Consumer<Integer> consumer) {
        return this.tickStartCallbacks.remove(consumer);
    }

    @Override
    public boolean addTickEndCallback(Consumer<Integer> consumer) {
        return this.tickEndCallbacks.add(consumer);
    }

    @Override
    public boolean removeTickEndCallback(Consumer<Integer> consumer) {
        return this.tickEndCallbacks.add(consumer);
    }

    private void tickStartCallback(int tickNumber) {
        this.tickStartCallbacks.forEach(consumer -> consumer.accept(tickNumber));
    }

    private void tickEndCallback(int tickNumber) {
        this.tickEndCallbacks.forEach(consumer -> consumer.accept(tickNumber));
    }

    public static boolean isCompatible() {
        try {
            Class.forName("com.destroystokyo.paper.event.server.ServerTickStartEvent");
        }
        catch (ClassNotFoundException e) {
            return false;
        }
        return true;
    }
}

