/*
 * Decompiled with CFR 0.152.
 */
package com.froobworld.viewdistancetweaks;

import com.froobworld.viewdistancetweaks.HookManager;
import com.froobworld.viewdistancetweaks.TaskManager;
import com.froobworld.viewdistancetweaks.command.VdtCommand;
import com.froobworld.viewdistancetweaks.config.VdtConfig;
import com.froobworld.viewdistancetweaks.limiter.ClientViewDistanceManager;
import com.froobworld.viewdistancetweaks.metrics.VdtMetrics;
import com.froobworld.viewdistancetweaks.placeholder.VdtExpansion;
import com.froobworld.viewdistancetweaks.util.SpigotViewDistanceSyncer;
import org.bukkit.Bukkit;
import org.bukkit.command.CommandExecutor;
import org.bukkit.plugin.Plugin;
import org.bukkit.plugin.java.JavaPlugin;

public class ViewDistanceTweaks
extends JavaPlugin {
    private VdtConfig vdtConfig;
    private HookManager hookManager;
    private TaskManager taskManager;
    private ClientViewDistanceManager clientViewDistanceManager;

    public void onEnable() {
        try {
            Class.forName("org.spigotmc.SpigotConfig");
        }
        catch (Exception ex) {
            this.getLogger().severe("ViewDistanceTweaks requires Spigot (or a fork such as Paper) in order to run.");
            Bukkit.getPluginManager().disablePlugin((Plugin)this);
            return;
        }
        this.vdtConfig = new VdtConfig(this);
        try {
            this.vdtConfig.load();
        }
        catch (Exception e) {
            this.getLogger().severe("Exception while loading configuration:");
            e.printStackTrace();
            Bukkit.getPluginManager().disablePlugin((Plugin)this);
            return;
        }
        if (!this.vdtConfig.enabled.get().booleanValue()) {
            this.getLogger().warning("ViewDistanceTweaks must be configured before it can be enabled. Edit the config.yml file in the plugin's data folder, setting the 'enabled' option to true when you are done, then reload or restart the server.");
            Bukkit.getPluginManager().disablePlugin((Plugin)this);
            return;
        }
        SpigotViewDistanceSyncer.syncSpigotViewDistances();
        this.clientViewDistanceManager = new ClientViewDistanceManager(this);
        this.hookManager = new HookManager(this);
        this.hookManager.init();
        this.taskManager = new TaskManager(this);
        this.taskManager.init();
        this.registerCommands();
        this.initMetrics();
        if (Bukkit.getPluginManager().getPlugin("PlaceholderAPI") != null && new VdtExpansion(this).register()) {
            this.getLogger().info("Registered expansion for PlaceholderAPI.");
        }
        this.getLogger().info("Finished startup.");
    }

    public void onDisable() {
    }

    public void reload() throws Exception {
        this.vdtConfig.load();
        this.taskManager.reload();
    }

    private void registerCommands() {
        VdtCommand vdtCommand = new VdtCommand(this);
        this.getCommand("vdt").setExecutor((CommandExecutor)vdtCommand);
        this.getCommand("vdt").setPermission("viewdistancetweaks.command.vdt");
        this.getCommand("vdt").setTabCompleter(vdtCommand.getTabCompleter());
    }

    private void initMetrics() {
        new VdtMetrics(this);
    }

    public ClientViewDistanceManager getClientViewDistanceManager() {
        return this.clientViewDistanceManager;
    }

    public HookManager getHookManager() {
        return this.hookManager;
    }

    public TaskManager getTaskManager() {
        return this.taskManager;
    }

    public VdtConfig getVdtConfig() {
        return this.vdtConfig;
    }
}

