/*
 * Decompiled with CFR 0.152.
 */
package com.froobworld.viewdistancetweaks;

import com.froobworld.viewdistancetweaks.ViewDistanceTweaks;
import com.froobworld.viewdistancetweaks.hook.tick.PaperTickHook;
import com.froobworld.viewdistancetweaks.hook.viewdistance.ViewDistanceHook;
import com.froobworld.viewdistancetweaks.limiter.ManualViewDistanceManager;
import com.froobworld.viewdistancetweaks.limiter.ViewDistanceClamper;
import com.froobworld.viewdistancetweaks.limiter.ViewDistanceLimiter;
import com.froobworld.viewdistancetweaks.limiter.adjustmentmode.AdjustmentMode;
import com.froobworld.viewdistancetweaks.limiter.adjustmentmode.AlternativeReactiveAdjustmentMode;
import com.froobworld.viewdistancetweaks.limiter.adjustmentmode.MixedAdjustmentMode;
import com.froobworld.viewdistancetweaks.limiter.adjustmentmode.ProactiveAdjustmentMode;
import com.froobworld.viewdistancetweaks.limiter.adjustmentmode.ReactiveAdjustmentMode;
import com.froobworld.viewdistancetweaks.util.MsptTracker;
import com.froobworld.viewdistancetweaks.util.TpsTracker;
import java.util.List;
import java.util.stream.Collectors;
import org.bukkit.Bukkit;
import org.bukkit.World;
import org.bukkit.event.EventHandler;
import org.bukkit.event.Listener;
import org.bukkit.event.world.WorldLoadEvent;
import org.bukkit.plugin.Plugin;

public class TaskManager {
    private ViewDistanceTweaks viewDistanceTweaks;
    private TpsTracker tpsTracker;
    private MsptTracker msptTracker;
    private ViewDistanceLimiter limiterTask;
    private ViewDistanceLimiter noTickLimiterTask;
    private ViewDistanceClamper simulationDistanceClamper;
    private ViewDistanceClamper viewDistanceClamper;
    private ManualViewDistanceManager manualSimulationDistanceManager;
    private ManualViewDistanceManager manualViewDistanceManager;

    public TaskManager(ViewDistanceTweaks viewDistanceTweaks) {
        this.viewDistanceTweaks = viewDistanceTweaks;
    }

    public void init() {
        this.initTpsTracker();
        this.initMsptTracker();
        this.initViewDistanceClampers();
        this.initManualViewDistanceManagers();
        this.initLimiterTask();
        this.initNoTickLimiterTask();
    }

    public void reload() {
        this.tpsTracker.unregister();
        this.msptTracker.unregister();
        this.limiterTask.cancel();
        if (this.noTickLimiterTask != null) {
            this.noTickLimiterTask.cancel();
        }
        this.manualSimulationDistanceManager.cancel();
        if (this.manualViewDistanceManager != null) {
            this.manualViewDistanceManager.cancel();
        }
        this.init();
    }

    private void initTpsTracker() {
        this.tpsTracker = new TpsTracker(this.viewDistanceTweaks.getVdtConfig().reactiveMode.tpsTracker.collectionPeriod.get(), this.viewDistanceTweaks.getHookManager().getTickHook(), this.viewDistanceTweaks.getVdtConfig().reactiveMode.tpsTracker.trimOutliersPercent.get());
        this.tpsTracker.register();
    }

    private void initMsptTracker() {
        this.msptTracker = new MsptTracker(this.viewDistanceTweaks.getVdtConfig().paperSettings.alternativeReactiveModeSettings.msptTracker.collectionPeriod.get(), this.viewDistanceTweaks.getHookManager().getTickHook());
        this.msptTracker.register();
    }

    private void initManualViewDistanceManagers() {
        this.manualSimulationDistanceManager = new ManualViewDistanceManager(this.viewDistanceTweaks, this.viewDistanceTweaks.getHookManager().getSimulationDistanceHook());
        ViewDistanceHook noTickViewDistanceHook = this.viewDistanceTweaks.getHookManager().getViewDistanceHook();
        if (noTickViewDistanceHook != null) {
            this.manualViewDistanceManager = new ManualViewDistanceManager(this.viewDistanceTweaks, noTickViewDistanceHook);
        }
    }

    private void initLimiterTask() {
        AdjustmentMode proactiveAdjustmentMode = null;
        AdjustmentMode reactiveAdjustmentMode = null;
        AdjustmentMode.Mode mode = this.viewDistanceTweaks.getVdtConfig().adjustmentMode.get();
        if (mode == AdjustmentMode.Mode.REACTIVE || mode == AdjustmentMode.Mode.MIXED) {
            reactiveAdjustmentMode = PaperTickHook.isCompatible() && this.viewDistanceTweaks.getVdtConfig().paperSettings.alternativeReactiveModeSettings.useAlternativeSettings.get() != false ? new AlternativeReactiveAdjustmentMode(this.msptTracker, this.viewDistanceTweaks.getHookManager().getChunkCounter(), this.viewDistanceTweaks.getVdtConfig().paperSettings.alternativeReactiveModeSettings.increaseMsptThreshold.get(), this.viewDistanceTweaks.getVdtConfig().paperSettings.alternativeReactiveModeSettings.decreaseMsptThreshold.get(), this.viewDistanceTweaks.getVdtConfig().paperSettings.alternativeReactiveModeSettings.msptPrediction.historyLength.get(), this.viewDistanceTweaks.getVdtConfig().paperSettings.alternativeReactiveModeSettings.msptPrediction.enabled.get(), this.viewDistanceTweaks.getHookManager().getSimulationDistanceHook(), world -> this.viewDistanceTweaks.getVdtConfig().worldSettings.of((World)world).simulationDistance.exclude.get(), world -> this.viewDistanceTweaks.getVdtConfig().worldSettings.of((World)world).simulationDistance.maximumSimulationDistance.get(), world -> this.viewDistanceTweaks.getVdtConfig().worldSettings.of((World)world).simulationDistance.minimumSimulationDistance.get(), this.viewDistanceTweaks.getVdtConfig().passedChecksForIncrease.get(), this.viewDistanceTweaks.getVdtConfig().passedChecksForDecrease.get()) : new ReactiveAdjustmentMode(this.tpsTracker, this.viewDistanceTweaks.getHookManager().getChunkCounter(), this.viewDistanceTweaks.getVdtConfig().reactiveMode.increaseTpsThreshold.get(), this.viewDistanceTweaks.getVdtConfig().reactiveMode.decreaseTpsThreshold.get(), this.viewDistanceTweaks.getVdtConfig().reactiveMode.tpsPrediction.historyLength.get(), this.viewDistanceTweaks.getVdtConfig().reactiveMode.tpsPrediction.enabled.get(), this.viewDistanceTweaks.getHookManager().getSimulationDistanceHook(), world -> this.viewDistanceTweaks.getVdtConfig().worldSettings.of((World)world).simulationDistance.exclude.get(), world -> this.viewDistanceTweaks.getVdtConfig().worldSettings.of((World)world).simulationDistance.maximumSimulationDistance.get(), world -> this.viewDistanceTweaks.getVdtConfig().worldSettings.of((World)world).simulationDistance.minimumSimulationDistance.get(), this.viewDistanceTweaks.getVdtConfig().passedChecksForIncrease.get(), this.viewDistanceTweaks.getVdtConfig().passedChecksForDecrease.get());
        }
        if (mode == AdjustmentMode.Mode.PROACTIVE || mode == AdjustmentMode.Mode.MIXED) {
            proactiveAdjustmentMode = new ProactiveAdjustmentMode(this.viewDistanceTweaks.getVdtConfig().proactiveMode.globalTickingChunkCountTarget.get(), this.viewDistanceTweaks.getHookManager().getSimulationDistanceHook(), this.viewDistanceTweaks.getHookManager().getChunkCounter(), world -> this.viewDistanceTweaks.getVdtConfig().worldSettings.of((World)world).simulationDistance.exclude.get(), world -> this.viewDistanceTweaks.getVdtConfig().worldSettings.of((World)world).simulationDistance.maximumSimulationDistance.get(), world -> this.viewDistanceTweaks.getVdtConfig().worldSettings.of((World)world).simulationDistance.minimumSimulationDistance.get(), this.viewDistanceTweaks.getVdtConfig().passedChecksForIncrease.get(), this.viewDistanceTweaks.getVdtConfig().passedChecksForDecrease.get());
        }
        MixedAdjustmentMode adjustmentMode = mode == AdjustmentMode.Mode.REACTIVE ? reactiveAdjustmentMode : (mode == AdjustmentMode.Mode.PROACTIVE ? proactiveAdjustmentMode : new MixedAdjustmentMode(proactiveAdjustmentMode, reactiveAdjustmentMode, AdjustmentMode.Adjustment::strongest));
        this.limiterTask = new ViewDistanceLimiter(this.viewDistanceTweaks, this.viewDistanceTweaks.getHookManager().getSimulationDistanceHook(), adjustmentMode, this.manualSimulationDistanceManager, this.viewDistanceTweaks.getVdtConfig().logChanges.get(), "Changed simulation distance of {0} ({1} -> {2})");
        this.limiterTask.start(this.viewDistanceTweaks.getVdtConfig().ticksPerCheck.get(), this.viewDistanceTweaks.getVdtConfig().startUpDelay.get());
    }

    private void initNoTickLimiterTask() {
        ViewDistanceHook noTickViewDistanceHook = this.viewDistanceTweaks.getHookManager().getViewDistanceHook();
        if (noTickViewDistanceHook != null) {
            ProactiveAdjustmentMode noTickAdjustmentMode = new ProactiveAdjustmentMode(this.viewDistanceTweaks.getVdtConfig().proactiveMode.globalNonTickingChunkCountTarget.get(), noTickViewDistanceHook, this.viewDistanceTweaks.getHookManager().getNoTickChunkCounter(), world -> this.viewDistanceTweaks.getVdtConfig().worldSettings.of((World)world).viewDistance.exclude.get(), world -> this.viewDistanceTweaks.getVdtConfig().worldSettings.of((World)world).viewDistance.maximumViewDistance.get(), world -> this.viewDistanceTweaks.getVdtConfig().worldSettings.of((World)world).viewDistance.minimumViewDistance.get(), this.viewDistanceTweaks.getVdtConfig().passedChecksForIncrease.get(), this.viewDistanceTweaks.getVdtConfig().passedChecksForDecrease.get());
            this.noTickLimiterTask = new ViewDistanceLimiter(this.viewDistanceTweaks, noTickViewDistanceHook, noTickAdjustmentMode, this.manualViewDistanceManager, this.viewDistanceTweaks.getVdtConfig().logChanges.get(), "Changed view distance of {0} ({1} -> {2})");
            this.noTickLimiterTask.start(this.viewDistanceTweaks.getVdtConfig().ticksPerCheck.get(), this.viewDistanceTweaks.getVdtConfig().startUpDelay.get());
        }
    }

    private void initViewDistanceClampers() {
        this.simulationDistanceClamper = new ViewDistanceClamper(this.viewDistanceTweaks.getHookManager().getSimulationDistanceHook(), world -> this.viewDistanceTweaks.getVdtConfig().worldSettings.of((World)world).simulationDistance.maximumSimulationDistance.get(), world -> this.viewDistanceTweaks.getVdtConfig().worldSettings.of((World)world).simulationDistance.minimumSimulationDistance.get());
        List<Object> worldsToClamp = Bukkit.getWorlds().stream().filter(world -> this.viewDistanceTweaks.getVdtConfig().worldSettings.of((World)world).simulationDistance.exclude.get() == false).collect(Collectors.toList());
        this.simulationDistanceClamper.clampWorlds(worldsToClamp);
        worldsToClamp = Bukkit.getWorlds().stream().filter(world -> this.viewDistanceTweaks.getVdtConfig().worldSettings.of((World)world).viewDistance.exclude.get() == false).collect(Collectors.toList());
        ViewDistanceHook viewDistanceHook = this.viewDistanceTweaks.getHookManager().getViewDistanceHook();
        if (viewDistanceHook != null) {
            this.viewDistanceClamper = new ViewDistanceClamper(viewDistanceHook, world -> this.viewDistanceTweaks.getVdtConfig().worldSettings.of((World)world).viewDistance.maximumViewDistance.get(), world -> this.viewDistanceTweaks.getVdtConfig().worldSettings.of((World)world).viewDistance.minimumViewDistance.get());
            this.viewDistanceClamper.clampWorlds(worldsToClamp);
        }
        Bukkit.getPluginManager().registerEvents(new Listener(){

            @EventHandler
            void onWorldLoad(WorldLoadEvent event) {
                if (!((TaskManager)TaskManager.this).viewDistanceTweaks.getVdtConfig().worldSettings.of((World)event.getWorld()).simulationDistance.exclude.get().booleanValue()) {
                    TaskManager.this.simulationDistanceClamper.clampWorld(event.getWorld());
                }
                if (TaskManager.this.viewDistanceClamper != null && !((TaskManager)TaskManager.this).viewDistanceTweaks.getVdtConfig().worldSettings.of((World)event.getWorld()).viewDistance.exclude.get().booleanValue()) {
                    TaskManager.this.viewDistanceClamper.clampWorld(event.getWorld());
                }
            }
        }, (Plugin)this.viewDistanceTweaks);
    }

    public TpsTracker getTpsTracker() {
        return this.tpsTracker;
    }

    public MsptTracker getMsptTracker() {
        return this.msptTracker;
    }

    public ManualViewDistanceManager getManualSimulationDistanceManager() {
        return this.manualSimulationDistanceManager;
    }

    public ManualViewDistanceManager getManualViewDistanceManager() {
        return this.manualViewDistanceManager;
    }
}

