/*
 * Decompiled with CFR 0.152.
 */
package com.froobworld.viewdistancetweaks;

import com.froobworld.viewdistancetweaks.ViewDistanceTweaks;
import com.froobworld.viewdistancetweaks.hook.tick.PaperTickHook;
import com.froobworld.viewdistancetweaks.hook.tick.SpigotTickHook;
import com.froobworld.viewdistancetweaks.hook.tick.TickHook;
import com.froobworld.viewdistancetweaks.hook.viewdistance.PaperSimulationDistanceHook;
import com.froobworld.viewdistancetweaks.hook.viewdistance.PaperViewDistanceHook;
import com.froobworld.viewdistancetweaks.hook.viewdistance.SimulationDistanceHook;
import com.froobworld.viewdistancetweaks.hook.viewdistance.SpigotSimulationDistanceHook;
import com.froobworld.viewdistancetweaks.hook.viewdistance.SpigotViewDistanceHook;
import com.froobworld.viewdistancetweaks.hook.viewdistance.ViewDistanceHook;
import com.froobworld.viewdistancetweaks.util.ChunkCounter;
import com.froobworld.viewdistancetweaks.util.NoTickChunkCounter;
import com.froobworld.viewdistancetweaks.util.PreferenceChooser;
import com.froobworld.viewdistancetweaks.util.StandardChunkCounter;
import org.bukkit.World;

public class HookManager {
    private final ViewDistanceTweaks viewDistanceTweaks;
    private TickHook tickHook;
    private SimulationDistanceHook simulationDistanceHook;
    private ViewDistanceHook viewDistanceHook;
    private ChunkCounter chunkCounter;
    private ChunkCounter noTickChunkCounter;
    private ChunkCounter actualChunkCounter;
    private ChunkCounter actualNoTickChunkCounter;

    public HookManager(ViewDistanceTweaks viewDistanceTweaks) {
        this.viewDistanceTweaks = viewDistanceTweaks;
    }

    public TickHook getTickHook() {
        return this.tickHook;
    }

    public SimulationDistanceHook getSimulationDistanceHook() {
        return this.simulationDistanceHook;
    }

    public ViewDistanceHook getViewDistanceHook() {
        return this.viewDistanceHook;
    }

    public ChunkCounter getChunkCounter() {
        return this.chunkCounter;
    }

    public ChunkCounter getNoTickChunkCounter() {
        return this.noTickChunkCounter;
    }

    public ChunkCounter getActualChunkCounter() {
        return this.actualChunkCounter;
    }

    public ChunkCounter getActualNoTickChunkCounter() {
        return this.actualNoTickChunkCounter;
    }

    public void init() {
        this.simulationDistanceHook = (SimulationDistanceHook)PreferenceChooser.bestChoice(PaperSimulationDistanceHook::new, PaperSimulationDistanceHook::isCompatible).nextBestChoice(SpigotSimulationDistanceHook::new, SpigotSimulationDistanceHook::isCompatible).get();
        if (this.simulationDistanceHook == null) {
            throw new IllegalStateException("No simulation distance hook is available. Incompatible version?");
        }
        this.viewDistanceTweaks.getLogger().info("Using " + this.simulationDistanceHook.getClass().getSimpleName() + " for the simulation distance hook.");
        this.viewDistanceHook = (ViewDistanceHook)PreferenceChooser.bestChoice(PaperViewDistanceHook::new, PaperViewDistanceHook::isCompatible).nextBestChoice(() -> new SpigotViewDistanceHook(this.viewDistanceTweaks.getClientViewDistanceManager()), SpigotViewDistanceHook::isCompatible).get();
        this.viewDistanceTweaks.getLogger().info(this.viewDistanceHook != null ? "Using " + this.viewDistanceHook.getClass().getSimpleName() + " for the view distance hook." : "No hook available for view distance.");
        this.tickHook = PreferenceChooser.bestChoice(PaperTickHook::new, PaperTickHook::isCompatible).defaultChoice(SpigotTickHook::new);
        this.tickHook.register(this.viewDistanceTweaks);
        this.viewDistanceTweaks.getLogger().info("Using " + this.tickHook.getClass().getSimpleName() + " for the tick hook.");
        this.chunkCounter = new StandardChunkCounter(world -> this.viewDistanceTweaks.getVdtConfig().worldSettings.of((World)world).chunkWeight.get(), world -> this.viewDistanceTweaks.getVdtConfig().worldSettings.of((World)world).chunkCounter.excludeOverlap.get());
        this.noTickChunkCounter = new NoTickChunkCounter(this.simulationDistanceHook, world -> this.viewDistanceTweaks.getVdtConfig().worldSettings.of((World)world).chunkWeight.get(), world -> this.viewDistanceTweaks.getVdtConfig().worldSettings.of((World)world).chunkCounter.excludeOverlap.get());
        this.actualChunkCounter = new StandardChunkCounter(world -> 1.0, world -> true);
        this.actualNoTickChunkCounter = new NoTickChunkCounter(this.simulationDistanceHook, world -> 1.0, world -> true);
    }
}

