/*
 * Decompiled with CFR 0.152.
 */
package me.lucko.luckperms.lib.commodore.file;

import com.mojang.brigadier.arguments.ArgumentType;
import java.lang.reflect.Constructor;
import me.lucko.luckperms.lib.commodore.MinecraftArgumentTypes;
import me.lucko.luckperms.lib.commodore.file.ArgumentTypeParser;
import me.lucko.luckperms.lib.commodore.file.ParseException;
import me.lucko.luckperms.lib.commodore.file.Token;
import me.lucko.luckperms.lib.commodore.file.TokenStream;
import org.bukkit.NamespacedKey;

public class MinecraftArgumentTypeParser
implements ArgumentTypeParser {
    public static final MinecraftArgumentTypeParser INSTANCE = new MinecraftArgumentTypeParser();

    private MinecraftArgumentTypeParser() {
    }

    public boolean canParse(String namespace, String name) {
        if (namespace.equals("minecraft") && (name.equals("entity") || name.equals("score_holder"))) {
            return true;
        }
        return MinecraftArgumentTypes.isRegistered(new NamespacedKey(namespace, name));
    }

    public ArgumentType<?> parse(String namespace, String name, TokenStream tokens) throws ParseException {
        if (namespace.equals("minecraft")) {
            if (name.equals("entity")) {
                return this.parseEntityArgumentType(tokens);
            }
            if (name.equals("score_holder")) {
                return MinecraftArgumentTypeParser.parseScoreHolderArgumentType(tokens);
            }
        }
        try {
            return MinecraftArgumentTypes.getByKey(new NamespacedKey(namespace, name));
        }
        catch (Throwable e) {
            throw tokens.createException("Invalid key for argument type (not found in registry): " + namespace + ":" + name, e);
        }
    }

    private ArgumentType<?> parseEntityArgumentType(TokenStream tokens) throws ParseException {
        boolean playersOnly;
        boolean single;
        String entitySelectionType;
        Token token = tokens.next();
        if (!(token instanceof Token.StringToken)) {
            throw tokens.createException("Expected string token for entity selection type but got " + token);
        }
        switch (entitySelectionType = ((Token.StringToken)token).getString()) {
            case "entity": {
                single = true;
                playersOnly = false;
                break;
            }
            case "entities": {
                single = false;
                playersOnly = false;
                break;
            }
            case "player": {
                single = true;
                playersOnly = true;
                break;
            }
            case "players": {
                single = false;
                playersOnly = true;
                break;
            }
            default: {
                throw tokens.createException("Unknown entity selection type: " + entitySelectionType);
            }
        }
        return MinecraftArgumentTypeParser.constructMinecraftArgumentType(NamespacedKey.minecraft((String)"entity"), new Class[]{Boolean.TYPE, Boolean.TYPE}, single, playersOnly);
    }

    private static ArgumentType<?> parseScoreHolderArgumentType(TokenStream tokens) throws ParseException {
        boolean multiple = false;
        if (tokens.peek() instanceof Token.StringToken) {
            multiple = MinecraftArgumentTypeParser.parseBoolean(tokens);
        }
        return MinecraftArgumentTypeParser.constructMinecraftArgumentType(NamespacedKey.minecraft((String)"score_holder"), new Class[]{Boolean.TYPE}, multiple);
    }

    private static ArgumentType<?> constructMinecraftArgumentType(NamespacedKey key, Class<?>[] argTypes, Object ... args) {
        try {
            Constructor<ArgumentType<?>> constructor = MinecraftArgumentTypes.getClassByKey(key).getDeclaredConstructor(argTypes);
            constructor.setAccessible(true);
            return constructor.newInstance(args);
        }
        catch (ReflectiveOperationException e) {
            throw new RuntimeException(e);
        }
    }

    private static boolean parseBoolean(TokenStream tokens) throws ParseException {
        Token token = tokens.next();
        if (!(token instanceof Token.StringToken)) {
            throw tokens.createException("Expected string token for boolean but got " + token);
        }
        String value = ((Token.StringToken)token).getString();
        if (value.equals("true")) {
            return true;
        }
        if (value.equals("false")) {
            return false;
        }
        throw tokens.createException("Expected true/false but got " + value);
    }
}

