/*
 * Decompiled with CFR 0.152.
 */
package com.onarandombox.multiverseinventories.util;

import com.onarandombox.multiverseinventories.MultiverseInventories;
import com.onarandombox.multiverseinventories.utils.InvLogging;
import org.bukkit.Bukkit;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Player;
import org.bukkit.permissions.Permission;
import org.bukkit.permissions.PermissionDefault;
import org.bukkit.plugin.PluginManager;

public enum Perm {
    COMMAND_INFO(new Permission("multiverse.inventories.info", "Displays information about a world or group.", PermissionDefault.OP)),
    COMMAND_LIST(new Permission("multiverse.inventories.list", "Displays a list of groups.", PermissionDefault.OP)),
    COMMAND_RELOAD(new Permission("multiverse.inventories.reload", "Reloads config file.", PermissionDefault.OP)),
    COMMAND_IMPORT(new Permission("multiverse.inventories.import", "Imports data from MultiInv/WorldInventories", PermissionDefault.OP)),
    COMMAND_GROUP(new Permission("multiverse.inventories.group", "Begins a conversation about groups.", PermissionDefault.OP)),
    COMMAND_ADDWORLD(new Permission("multiverse.inventories.addworld", "Adds a world to a world group", PermissionDefault.OP)),
    COMMAND_RMWORLD(new Permission("multiverse.inventories.removeworld", "Removes a world from a world group", PermissionDefault.OP)),
    COMMAND_ADDSHARES(new Permission("multiverse.inventories.addshares", "Adds share(s) to a world group", PermissionDefault.OP)),
    COMMAND_RMSHARES(new Permission("multiverse.inventories.removeshares", "Removes share(s) from a world group", PermissionDefault.OP)),
    COMMAND_CREATEGROUP(new Permission("multiverse.inventories.creategroup", "Creates a world group", PermissionDefault.OP)),
    COMMAND_DELETEGROUP(new Permission("multiverse.inventories.deletegroup", "Deletes a world group", PermissionDefault.OP)),
    COMMAND_SPAWN(new Permission("multiverse.inventories.spawn.self", "teleport yourself to group spawn", PermissionDefault.OP)),
    COMMAND_SPAWN_OTHER(new Permission("multiverse.inventories.spawn.other", "teleport other to group spawn", PermissionDefault.OP)),
    COMMAND_DEBUG(new Permission("multiverse.inventories.debug", "Spams the console a bunch.", PermissionDefault.OP)),
    BYPASS_GROUP_ALL(new Permission("mvinv.bypass.group.*", "", PermissionDefault.FALSE)),
    BYPASS_GROUP("mvinv.bypass.group."){

        private String getBypassMessage(Player player, String name) {
            return "Player: " + player.getName() + " has bypass perms for group: " + name;
        }
    }
    ,
    BYPASS_WORLD_ALL(new Permission("mvinv.bypass.world.*", "", PermissionDefault.FALSE)),
    BYPASS_WORLD("mvinv.bypass.world."){

        private String getBypassMessage(Player player, String name) {
            return "Player: " + player.getName() + " has bypass perms for world: " + name;
        }
    }
    ,
    BYPASS_GAME_MODE_ALL(new Permission("mvinv.bypass.gamemode.*", "", PermissionDefault.FALSE)),
    BYPASS_GAME_MODE("mvinv.bypass.gamemode."){

        private String getBypassMessage(Player player, String name) {
            return "Player: " + player.getName() + " has bypass perms for game mode: " + name;
        }
    }
    ,
    BYPASS_ALL(new Permission("mvinv.bypass.*", "Allows bypassing all of your groups/worlds and constantly use the same inventory", PermissionDefault.FALSE));

    private Permission perm = null;
    private String permNode = "";
    private static MultiverseInventories inventories;

    private Perm(Permission perm) {
        this.perm = perm;
    }

    private Perm(String permNode) {
        this.permNode = permNode;
    }

    public Permission getPermission() {
        return this.perm;
    }

    public String getNode() {
        return this.permNode;
    }

    public Permission getBypassPermission(String finalNode) {
        String bypassNode = this.getNode() + finalNode;
        InvLogging.finer("Checking node " + bypassNode + "...", new Object[0]);
        Permission permission = Bukkit.getPluginManager().getPermission(bypassNode);
        if (permission == null) {
            permission = new Permission(bypassNode, PermissionDefault.FALSE);
            switch (this) {
                case BYPASS_GROUP: {
                    permission.addParent(BYPASS_GROUP_ALL.getPermission(), true);
                    break;
                }
                case BYPASS_WORLD: {
                    permission.addParent(BYPASS_WORLD_ALL.getPermission(), true);
                    break;
                }
                case BYPASS_GAME_MODE: {
                    permission.addParent(BYPASS_GAME_MODE_ALL.getPermission(), true);
                    break;
                }
            }
            Bukkit.getPluginManager().addPermission(permission);
        }
        return permission;
    }

    public boolean hasBypass(Player player, String name) {
        if (inventories != null && !inventories.getMVIConfig().isUsingBypass()) {
            return false;
        }
        Permission bypassPerm = this.getBypassPermission(name);
        boolean hasBypass = player.hasPermission(bypassPerm);
        if (hasBypass) {
            InvLogging.fine("Player: " + player.getName() + " in World: " + player.getWorld().getName() + " has permission: " + bypassPerm.getName() + "(Default: " + bypassPerm.getDefault().toString() + ")!", new Object[0]);
        }
        return hasBypass;
    }

    public boolean has(CommandSender sender) {
        return sender.hasPermission(this.perm);
    }

    public static void register(MultiverseInventories plugin) {
        inventories = plugin;
        BYPASS_WORLD_ALL.getPermission().addParent(BYPASS_ALL.getPermission(), true);
        BYPASS_GROUP_ALL.getPermission().addParent(BYPASS_ALL.getPermission(), true);
        PluginManager pm = plugin.getServer().getPluginManager();
        for (Perm perm : Perm.values()) {
            if (perm.getPermission() == null) continue;
            pm.addPermission(perm.getPermission());
        }
    }

    static {
        inventories = null;
    }
}

