/*
 * Decompiled with CFR 0.152.
 */
package com.onarandombox.multiverseinventories.util;

import com.onarandombox.multiverseinventories.util.EnhancedConfigurationOptions;
import java.io.File;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.regex.Pattern;
import org.bukkit.configuration.Configuration;
import org.bukkit.configuration.MemoryConfiguration;
import org.bukkit.configuration.file.YamlConfiguration;
import org.bukkit.plugin.Plugin;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class EnhancedConfiguration
extends YamlConfiguration {
    private final Pattern pattern = Pattern.compile("\n");
    private final File file;
    private final Plugin plugin;
    private Exception exception;
    private Map<String, Object> cache = new HashMap<String, Object>();
    private boolean modified = false;
    private long last_modified = -1L;

    public EnhancedConfiguration(Plugin plugin) {
        this("config.yml", plugin);
    }

    public EnhancedConfiguration(String file, Plugin plugin) {
        this(new File(plugin.getDataFolder(), file), plugin);
    }

    public EnhancedConfiguration(File file) {
        this(file, null);
    }

    public EnhancedConfiguration(File file, Plugin plugin) {
        this.file = file;
        this.plugin = plugin;
        this.options = new EnhancedConfigurationOptions(this);
        this.load();
    }

    public final boolean load() {
        if (this.last_modified != -1L && !this.isFileModified()) {
            return true;
        }
        try {
            this.load(this.file);
            this.clearCache();
            this.last_modified = this.file.lastModified();
            return true;
        }
        catch (Exception ex) {
            this.exception = ex;
            return false;
        }
    }

    public final boolean save() {
        try {
            this.save(this.file);
            this.modified = false;
            return true;
        }
        catch (Exception ex) {
            this.exception = ex;
            return false;
        }
    }

    public Exception getLastException() {
        return this.exception;
    }

    public boolean loadDefaults() {
        try {
            return this.loadDefaults(this.file.getName());
        }
        catch (Exception ex) {
            this.exception = ex;
            return false;
        }
    }

    public boolean loadDefaults(String filename) {
        try {
            return this.loadDefaults(this.plugin.getResource(filename));
        }
        catch (Exception ex) {
            this.exception = ex;
            return false;
        }
    }

    public boolean loadDefaults(InputStream filestream) {
        try {
            this.setDefaults((Configuration)EnhancedConfiguration.loadConfiguration((InputStream)filestream));
            this.clearCache();
            return true;
        }
        catch (Exception ex) {
            this.exception = ex;
            return false;
        }
    }

    public boolean saveDefaults() {
        this.options().copyDefaults(true);
        this.options().copyHeader(true);
        return this.save();
    }

    public boolean checkDefaults() {
        if (this.getDefaults() == null) {
            return true;
        }
        return this.getKeys(true).containsAll(this.getDefaults().getKeys(true));
    }

    public final void clearDefaults() {
        this.setDefaults((Configuration)new MemoryConfiguration());
    }

    public final void clearFile() {
        this.cache.clear();
        this.map.clear();
    }

    public boolean needsUpdate() {
        return !this.fileExists() || !this.checkDefaults() || this.isModified();
    }

    public boolean fileExists() {
        try {
            return this.file.exists();
        }
        catch (Exception ex) {
            this.exception = ex;
            return false;
        }
    }

    public EnhancedConfigurationOptions options() {
        return (EnhancedConfigurationOptions)this.options;
    }

    public Object get(String path, Object def) {
        Object value = this.cache.get(path);
        if (value != null) {
            return value;
        }
        value = super.get(path, def);
        if (value != null) {
            this.cache.put(path, value);
        }
        return value;
    }

    public void set(String path, Object value) {
        if (value == null && this.cache.containsKey(path)) {
            this.cache.remove(path);
            this.modified = true;
        } else if (value != null) {
            if (!value.equals(this.get(path))) {
                this.modified = true;
            }
            this.cache.put(path, value);
        }
        super.set(path, value);
    }

    public void unset(String path) {
        this.set(path, null);
    }

    public List<?> getList(String path, List<?> def) {
        List list = super.getList(path, def);
        return list == null ? new ArrayList(0) : list;
    }

    public void clearCache() {
        this.cache.clear();
    }

    public String saveToString() {
        String separator = System.getProperty("line.separator");
        if (separator.equals("\n")) {
            return super.saveToString();
        }
        return this.pattern.matcher(super.saveToString()).replaceAll(separator);
    }

    public Plugin getPlugin() {
        return this.plugin;
    }

    protected File getFile() {
        return this.file;
    }

    public boolean isModified() {
        return this.modified;
    }

    public boolean isFileModified() {
        try {
            return this.last_modified != this.file.lastModified();
        }
        catch (Exception e) {
            this.exception = e;
            return false;
        }
    }
}

