/*
 * Decompiled with CFR 0.152.
 */
package com.onarandombox.multiverseinventories.util;

import com.onarandombox.multiverseinventories.util.EnhancedConfiguration;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.StringWriter;
import java.io.UnsupportedEncodingException;
import java.io.Writer;
import java.util.HashMap;
import java.util.List;
import org.bukkit.configuration.file.FileConfiguration;

public final class CommentedYamlConfiguration {
    private HashMap<String, String> comments = new HashMap();
    private File file;
    private FileConfiguration config = null;
    private boolean doComments;

    public CommentedYamlConfiguration(File file, boolean doComments) {
        this.file = file;
        this.doComments = doComments;
    }

    public void load() throws UnsupportedEncodingException {
        this.config = new EnhancedConfiguration(this.file);
    }

    public FileConfiguration getConfig() {
        return this.config;
    }

    public boolean save() {
        boolean saved = true;
        try {
            this.config.save(this.file);
        }
        catch (Exception e) {
            saved = false;
        }
        if (!this.doComments) {
            return saved;
        }
        if (!this.comments.isEmpty() && saved) {
            String[] yamlContents = this.convertFileToString(this.file).split("[" + System.getProperty("line.separator") + "]");
            StringBuilder newContents = new StringBuilder();
            String initialContents = this.config.options().header();
            if (initialContents == null) {
                initialContents = "";
            }
            newContents.append(initialContents).append(System.getProperty("line.separator")).append(System.getProperty("line.separator"));
            StringBuilder currentPath = new StringBuilder();
            boolean commentedPath = false;
            boolean node = false;
            int depth = 0;
            boolean firstLine = true;
            for (String line : yamlContents) {
                if (firstLine) {
                    firstLine = false;
                    if (line.startsWith("#")) continue;
                }
                if (line.contains(": ") || line.length() > 1 && line.charAt(line.length() - 1) == ':') {
                    commentedPath = false;
                    node = true;
                    int index = 0;
                    index = line.indexOf(": ");
                    if (index < 0) {
                        index = line.length() - 1;
                    }
                    if (currentPath.toString().isEmpty()) {
                        currentPath = new StringBuilder(line.substring(0, index));
                    } else {
                        int whiteSpace = 0;
                        for (int n = 0; n < line.length() && line.charAt(n) == ' '; ++n) {
                            ++whiteSpace;
                        }
                        if (whiteSpace / 2 > depth) {
                            currentPath.append(".").append(line.substring(whiteSpace, index));
                            ++depth;
                        } else if (whiteSpace / 2 < depth) {
                            int newDepth = whiteSpace / 2;
                            for (int i = 0; i < depth - newDepth; ++i) {
                                currentPath.replace(currentPath.lastIndexOf("."), currentPath.length(), "");
                            }
                            int lastIndex = currentPath.lastIndexOf(".");
                            if (lastIndex < 0) {
                                currentPath = new StringBuilder();
                            } else {
                                currentPath.replace(currentPath.lastIndexOf("."), currentPath.length(), "").append(".");
                            }
                            currentPath.append(line.substring(whiteSpace, index));
                            depth = newDepth;
                        } else {
                            int lastIndex = currentPath.lastIndexOf(".");
                            if (lastIndex < 0) {
                                currentPath = new StringBuilder();
                            } else {
                                currentPath.replace(currentPath.lastIndexOf("."), currentPath.length(), "").append(".");
                            }
                            currentPath.append(line.substring(whiteSpace, index));
                        }
                    }
                } else {
                    node = false;
                }
                StringBuilder newLine = new StringBuilder(line);
                if (node) {
                    String comment = null;
                    if (!commentedPath) {
                        comment = this.comments.get(currentPath.toString());
                    }
                    if (comment != null && !comment.isEmpty()) {
                        newLine.insert(0, System.getProperty("line.separator")).insert(0, comment);
                        comment = null;
                        commentedPath = true;
                    }
                }
                newLine.append(System.getProperty("line.separator"));
                newContents.append(newLine.toString());
            }
            try {
                this.stringToFile(newContents.toString(), this.file);
            }
            catch (IOException e) {
                saved = false;
            }
        }
        return saved;
    }

    public void addComment(String path, List<String> commentLines) {
        StringBuilder commentstring = new StringBuilder();
        String leadingSpaces = "";
        for (int n = 0; n < path.length(); ++n) {
            if (path.charAt(n) != '.') continue;
            leadingSpaces = leadingSpaces + "  ";
        }
        for (String line : commentLines) {
            line = !line.isEmpty() ? leadingSpaces + line : " ";
            if (commentstring.length() > 0) {
                commentstring.append("\r\n");
            }
            commentstring.append(line);
        }
        this.comments.put(path, commentstring.toString());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private String convertFileToString(File file) {
        int bufferSize = 1024;
        if (file != null && file.exists() && file.canRead() && !file.isDirectory()) {
            StringWriter writer = new StringWriter();
            FileInputStream is = null;
            char[] buffer = new char[1024];
            try {
                int n;
                is = new FileInputStream(file);
                BufferedReader reader = new BufferedReader(new InputStreamReader((InputStream)is, "UTF-8"));
                while ((n = reader.read(buffer)) != -1) {
                    ((Writer)writer).write(buffer, 0, n);
                }
            }
            catch (IOException e) {
                e.printStackTrace();
            }
            finally {
                if (is != null) {
                    try {
                        ((InputStream)is).close();
                    }
                    catch (IOException iOException) {}
                }
            }
            return ((Object)writer).toString();
        }
        return "";
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean stringToFile(String source, File file) throws IOException {
        OutputStreamWriter out = null;
        try {
            out = new OutputStreamWriter((OutputStream)new FileOutputStream(file), "UTF-8");
            source.replaceAll("\n", System.getProperty("line.separator"));
            out.write(source);
            out.close();
            boolean bl = true;
            return bl;
        }
        catch (IOException e) {
            e.printStackTrace();
            boolean bl = false;
            return bl;
        }
        finally {
            if (out != null) {
                try {
                    out.close();
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
            }
        }
    }
}

