/*
 * Decompiled with CFR 0.152.
 */
package com.onarandombox.multiverseinventories.share;

import com.onarandombox.multiverseinventories.MultiverseInventories;
import com.onarandombox.multiverseinventories.WorldGroup;
import com.onarandombox.multiverseinventories.profile.PlayerProfile;
import com.onarandombox.multiverseinventories.share.DefaultSerializer;
import com.onarandombox.multiverseinventories.share.InventorySerializer;
import com.onarandombox.multiverseinventories.share.LocationSerializer;
import com.onarandombox.multiverseinventories.share.PotionEffectSerializer;
import com.onarandombox.multiverseinventories.share.ProfileEntry;
import com.onarandombox.multiverseinventories.share.Sharable;
import com.onarandombox.multiverseinventories.share.SharableGroup;
import com.onarandombox.multiverseinventories.share.SharableHandler;
import com.onarandombox.multiverseinventories.share.Shares;
import com.onarandombox.multiverseinventories.util.MinecraftTools;
import com.onarandombox.multiverseinventories.utils.InvLogging;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.bukkit.Location;
import org.bukkit.Material;
import org.bukkit.attribute.Attribute;
import org.bukkit.entity.Player;
import org.bukkit.inventory.ItemStack;
import org.bukkit.potion.PotionEffect;

public final class Sharables
implements Shares {
    private static final Shares ALL_SHARABLES = new Sharables(new LinkedHashSet<Sharable>());
    static final Map<String, Shares> LOOKUP_MAP = new HashMap<String, Shares>();
    private static MultiverseInventories inventories = null;
    public static final Sharable<ItemStack[]> ENDER_CHEST = new Sharable.Builder<ItemStack[]>("ender_chest", ItemStack[].class, new SharableHandler<ItemStack[]>(){

        @Override
        public void updateProfile(PlayerProfile profile, Player player) {
            profile.set(ENDER_CHEST, player.getEnderChest().getContents());
        }

        @Override
        public boolean updatePlayer(Player player, PlayerProfile profile) {
            ItemStack[] value = profile.get(ENDER_CHEST);
            if (value == null) {
                player.getEnderChest().setContents(MinecraftTools.fillWithAir(new ItemStack[27]));
                return false;
            }
            player.getEnderChest().setContents(value);
            return true;
        }
    }).serializer(new ProfileEntry(false, "enderChestContents"), new InventorySerializer(27)).altName("ender").build();
    public static final Sharable<ItemStack[]> INVENTORY = new Sharable.Builder<ItemStack[]>("inventory_contents", ItemStack[].class, new SharableHandler<ItemStack[]>(){

        @Override
        public void updateProfile(PlayerProfile profile, Player player) {
            profile.set(INVENTORY, player.getInventory().getContents());
        }

        @Override
        public boolean updatePlayer(Player player, PlayerProfile profile) {
            ItemStack[] value = profile.get(INVENTORY);
            if (value == null) {
                player.getInventory().setContents(MinecraftTools.fillWithAir(new ItemStack[36]));
                player.updateInventory();
                return false;
            }
            player.getInventory().setContents(value);
            player.updateInventory();
            return true;
        }
    }).serializer(new ProfileEntry(false, "inventoryContents"), new InventorySerializer(36)).build();
    public static final Sharable<ItemStack[]> ARMOR = new Sharable.Builder<ItemStack[]>("armor_contents", ItemStack[].class, new SharableHandler<ItemStack[]>(){

        @Override
        public void updateProfile(PlayerProfile profile, Player player) {
            profile.set(ARMOR, player.getInventory().getArmorContents());
        }

        @Override
        public boolean updatePlayer(Player player, PlayerProfile profile) {
            ItemStack[] value = profile.get(ARMOR);
            if (value == null) {
                player.getInventory().setArmorContents(MinecraftTools.fillWithAir(new ItemStack[4]));
                player.updateInventory();
                return false;
            }
            player.getInventory().setArmorContents(value);
            player.updateInventory();
            return true;
        }
    }).serializer(new ProfileEntry(false, "armorContents"), new InventorySerializer(4)).altName("armor").build();
    public static final Sharable<ItemStack> OFF_HAND = new Sharable.Builder<ItemStack>("off_hand", ItemStack.class, new SharableHandler<ItemStack>(){

        @Override
        public void updateProfile(PlayerProfile profile, Player player) {
            profile.set(OFF_HAND, player.getInventory().getItemInOffHand());
        }

        @Override
        public boolean updatePlayer(Player player, PlayerProfile profile) {
            ItemStack value = profile.get(OFF_HAND);
            if (value == null) {
                player.getInventory().setItemInOffHand(new ItemStack(Material.AIR));
                player.updateInventory();
                return false;
            }
            player.getInventory().setItemInOffHand(value);
            player.updateInventory();
            return true;
        }
    }).serializer(new ProfileEntry(false, "offHandItem"), new DefaultSerializer<ItemStack>(ItemStack.class)).altName("shield").build();
    public static final Sharable<Double> HEALTH = new Sharable.Builder<Double>("hit_points", Double.class, new SharableHandler<Double>(){

        @Override
        public void updateProfile(PlayerProfile profile, Player player) {
            profile.set(HEALTH, player.getHealth());
        }

        @Override
        public boolean updatePlayer(Player player, PlayerProfile profile) {
            Double value = profile.get(HEALTH);
            if (value == null) {
                player.setHealth(20.0);
                return false;
            }
            try {
                player.setHealth(value.doubleValue());
            }
            catch (IllegalArgumentException e) {
                InvLogging.fine("Invalid value '" + value + "': " + e.getMessage(), new Object[0]);
                player.setHealth(player.getAttribute(Attribute.GENERIC_MAX_HEALTH).getValue());
                return false;
            }
            return true;
        }
    }).stringSerializer(new ProfileEntry(true, "hp")).altName("health").altName("hp").altName("hitpoints").build();
    public static final Sharable<Integer> REMAINING_AIR = new Sharable.Builder<Integer>("remaining_air", Integer.class, new SharableHandler<Integer>(){

        @Override
        public void updateProfile(PlayerProfile profile, Player player) {
            profile.set(REMAINING_AIR, player.getRemainingAir());
        }

        @Override
        public boolean updatePlayer(Player player, PlayerProfile profile) {
            Integer value = profile.get(REMAINING_AIR);
            if (value == null) {
                player.setRemainingAir(300);
                return false;
            }
            try {
                player.setRemainingAir(value.intValue());
            }
            catch (IllegalArgumentException e) {
                InvLogging.fine("Invalid value '" + value + "': " + e.getMessage(), new Object[0]);
                player.setRemainingAir(300);
                return false;
            }
            return true;
        }
    }).stringSerializer(new ProfileEntry(true, "ra")).build();
    public static final Sharable<Integer> MAXIMUM_AIR = new Sharable.Builder<Integer>("maximum_air", Integer.class, new SharableHandler<Integer>(){

        @Override
        public void updateProfile(PlayerProfile profile, Player player) {
            profile.set(MAXIMUM_AIR, player.getMaximumAir());
        }

        @Override
        public boolean updatePlayer(Player player, PlayerProfile profile) {
            Integer value = profile.get(MAXIMUM_AIR);
            if (value == null) {
                player.setMaximumAir(300);
                return false;
            }
            try {
                player.setMaximumAir(value.intValue());
            }
            catch (IllegalArgumentException e) {
                InvLogging.fine("Invalid value '" + value + "': " + e.getMessage(), new Object[0]);
                player.setMaximumAir(300);
                return false;
            }
            return true;
        }
    }).stringSerializer(new ProfileEntry(true, "ma")).build();
    public static final Sharable<Float> FALL_DISTANCE = new Sharable.Builder<Float>("fall_distance", Float.class, new SharableHandler<Float>(){

        @Override
        public void updateProfile(PlayerProfile profile, Player player) {
            profile.set(FALL_DISTANCE, Float.valueOf(player.getFallDistance()));
        }

        @Override
        public boolean updatePlayer(Player player, PlayerProfile profile) {
            Float value = profile.get(FALL_DISTANCE);
            if (value == null) {
                player.setFallDistance(0.0f);
                return false;
            }
            try {
                player.setFallDistance(value.floatValue());
            }
            catch (IllegalArgumentException e) {
                InvLogging.fine("Invalid value '" + value + "': " + e.getMessage(), new Object[0]);
                player.setFallDistance(0.0f);
                return false;
            }
            return true;
        }
    }).stringSerializer(new ProfileEntry(true, "fd")).altName("falling").build();
    public static final Sharable<Integer> FIRE_TICKS = new Sharable.Builder<Integer>("fire_ticks", Integer.class, new SharableHandler<Integer>(){

        @Override
        public void updateProfile(PlayerProfile profile, Player player) {
            profile.set(FIRE_TICKS, player.getFireTicks());
        }

        @Override
        public boolean updatePlayer(Player player, PlayerProfile profile) {
            Integer value = profile.get(FIRE_TICKS);
            if (value == null) {
                player.setFireTicks(0);
                return false;
            }
            try {
                player.setFireTicks(value.intValue());
            }
            catch (IllegalArgumentException e) {
                InvLogging.fine("Invalid value '" + value + "': " + e.getMessage(), new Object[0]);
                player.setFireTicks(0);
                return false;
            }
            return true;
        }
    }).stringSerializer(new ProfileEntry(true, "ft")).altName("fire").altName("burning").build();
    public static final Sharable<Float> EXPERIENCE = new Sharable.Builder<Float>("xp", Float.class, new SharableHandler<Float>(){

        @Override
        public void updateProfile(PlayerProfile profile, Player player) {
            profile.set(EXPERIENCE, Float.valueOf(player.getExp()));
        }

        @Override
        public boolean updatePlayer(Player player, PlayerProfile profile) {
            Float value = profile.get(EXPERIENCE);
            if (value == null) {
                player.setExp(0.0f);
                return false;
            }
            try {
                player.setExp(value.floatValue());
            }
            catch (IllegalArgumentException e) {
                InvLogging.fine("Invalid value '" + value + "': " + e.getMessage(), new Object[0]);
                player.setExp(0.0f);
                return false;
            }
            return true;
        }
    }).stringSerializer(new ProfileEntry(true, "xp")).build();
    public static final Sharable<Integer> LEVEL = new Sharable.Builder<Integer>("lvl", Integer.class, new SharableHandler<Integer>(){

        @Override
        public void updateProfile(PlayerProfile profile, Player player) {
            profile.set(LEVEL, player.getLevel());
        }

        @Override
        public boolean updatePlayer(Player player, PlayerProfile profile) {
            Integer value = profile.get(LEVEL);
            if (value == null) {
                player.setLevel(0);
                return false;
            }
            try {
                player.setLevel(value.intValue());
            }
            catch (IllegalArgumentException e) {
                InvLogging.fine("Invalid value '" + value + "': " + e.getMessage(), new Object[0]);
                player.setLevel(0);
                return false;
            }
            return true;
        }
    }).stringSerializer(new ProfileEntry(true, "el")).build();
    public static final Sharable<Integer> TOTAL_EXPERIENCE = new Sharable.Builder<Integer>("total_xp", Integer.class, new SharableHandler<Integer>(){

        @Override
        public void updateProfile(PlayerProfile profile, Player player) {
            profile.set(TOTAL_EXPERIENCE, player.getTotalExperience());
        }

        @Override
        public boolean updatePlayer(Player player, PlayerProfile profile) {
            Integer value = profile.get(TOTAL_EXPERIENCE);
            if (value == null) {
                player.setTotalExperience(0);
                return false;
            }
            try {
                player.setTotalExperience(value.intValue());
            }
            catch (IllegalArgumentException e) {
                InvLogging.fine("Invalid value '" + value + "': " + e.getMessage(), new Object[0]);
                player.setTotalExperience(0);
                return false;
            }
            return true;
        }
    }).stringSerializer(new ProfileEntry(true, "txp")).build();
    public static final Sharable<Integer> FOOD_LEVEL = new Sharable.Builder<Integer>("food_level", Integer.class, new SharableHandler<Integer>(){

        @Override
        public void updateProfile(PlayerProfile profile, Player player) {
            profile.set(FOOD_LEVEL, player.getFoodLevel());
        }

        @Override
        public boolean updatePlayer(Player player, PlayerProfile profile) {
            Integer value = profile.get(FOOD_LEVEL);
            if (value == null) {
                player.setFoodLevel(20);
                return false;
            }
            try {
                player.setFoodLevel(value.intValue());
            }
            catch (IllegalArgumentException e) {
                InvLogging.fine("Invalid value '" + value + "': " + e.getMessage(), new Object[0]);
                player.setFoodLevel(20);
                return false;
            }
            return true;
        }
    }).stringSerializer(new ProfileEntry(true, "fl")).altName("food").build();
    public static final Sharable<Float> EXHAUSTION = new Sharable.Builder<Float>("exhaustion", Float.class, new SharableHandler<Float>(){

        @Override
        public void updateProfile(PlayerProfile profile, Player player) {
            profile.set(EXHAUSTION, Float.valueOf(player.getExhaustion()));
        }

        @Override
        public boolean updatePlayer(Player player, PlayerProfile profile) {
            Float value = profile.get(EXHAUSTION);
            if (value == null) {
                player.setExhaustion(0.0f);
                return false;
            }
            try {
                player.setExhaustion(value.floatValue());
            }
            catch (IllegalArgumentException e) {
                InvLogging.fine("Invalid value '" + value + "': " + e.getMessage(), new Object[0]);
                player.setExhaustion(0.0f);
                return false;
            }
            return true;
        }
    }).stringSerializer(new ProfileEntry(true, "ex")).altName("exhaust").altName("exh").build();
    public static final Sharable<Float> SATURATION = new Sharable.Builder<Float>("saturation", Float.class, new SharableHandler<Float>(){

        @Override
        public void updateProfile(PlayerProfile profile, Player player) {
            profile.set(SATURATION, Float.valueOf(player.getSaturation()));
        }

        @Override
        public boolean updatePlayer(Player player, PlayerProfile profile) {
            Float value = profile.get(SATURATION);
            if (value == null) {
                player.setSaturation(5.0f);
                return false;
            }
            try {
                player.setSaturation(value.floatValue());
            }
            catch (IllegalArgumentException e) {
                InvLogging.fine("Invalid value '" + value + "': " + e.getMessage(), new Object[0]);
                player.setSaturation(5.0f);
                return false;
            }
            return true;
        }
    }).stringSerializer(new ProfileEntry(true, "sa")).altName("sat").build();
    public static final Sharable<Location> BED_SPAWN = new Sharable.Builder<Location>("bed_spawn", Location.class, new SharableHandler<Location>(){

        @Override
        public void updateProfile(PlayerProfile profile, Player player) {
            Location bedSpawnLocation = null;
            try {
                bedSpawnLocation = player.getBedSpawnLocation();
            }
            catch (NullPointerException e) {
                StackTraceElement[] stackTrace = e.getStackTrace();
                String error = stackTrace.length > 1 ? stackTrace[0].toString() + stackTrace[1] : "NullPointerException thrown by Player#getBedSpawnLocation";
                InvLogging.warning(error + " - See https://github.com/Multiverse/Multiverse-Inventories/issues/374 for more details.", new Object[0]);
            }
            profile.set(BED_SPAWN, bedSpawnLocation);
        }

        @Override
        public boolean updatePlayer(Player player, PlayerProfile profile) {
            Location loc = profile.get(BED_SPAWN);
            if (loc == null) {
                player.setBedSpawnLocation(player.getWorld().getSpawnLocation());
                return false;
            }
            player.setBedSpawnLocation(loc, true);
            return true;
        }
    }).serializer(new ProfileEntry(false, "bedSpawnLocation"), new LocationSerializer()).altName("bedspawn").altName("bed").altName("beds").altName("bedspawns").build();
    public static final Sharable<Location> LAST_LOCATION = new Sharable.Builder<Location>("last_location", Location.class, new SharableHandler<Location>(){

        @Override
        public void updateProfile(PlayerProfile profile, Player player) {
        }

        @Override
        public boolean updatePlayer(Player player, PlayerProfile profile) {
            Location loc = profile.get(LAST_LOCATION);
            if (loc == null) {
                return false;
            }
            player.teleport(loc);
            return true;
        }
    }).serializer(new ProfileEntry(false, "lastLocation"), new LocationSerializer()).altName("loc").altName("location").altName("pos").altName("position").optional().build();
    public static final Sharable<Double> ECONOMY = new Sharable.Builder<Double>("economy", Double.class, new SharableHandler<Double>(){

        @Override
        public void updateProfile(PlayerProfile profile, Player player) {
            profile.set(ECONOMY, inventories.getCore().getEconomist().getBalance(player));
        }

        @Override
        public boolean updatePlayer(Player player, PlayerProfile profile) {
            Double money = profile.get(ECONOMY);
            if (money == null) {
                inventories.getCore().getEconomist().setBalance(player, 0.0);
                return false;
            }
            inventories.getCore().getEconomist().setBalance(player, money.doubleValue());
            return true;
        }
    }).stringSerializer(new ProfileEntry(false, "balance")).optional().altName("money").altName("econ").altName("cash").altName("balance").build();
    public static final Sharable<PotionEffect[]> POTIONS = new Sharable.Builder<PotionEffect[]>("potion_effects", PotionEffect[].class, new SharableHandler<PotionEffect[]>(){

        @Override
        public void updateProfile(PlayerProfile profile, Player player) {
            Collection potionEffects = player.getActivePotionEffects();
            profile.set(POTIONS, potionEffects.toArray(new PotionEffect[potionEffects.size()]));
        }

        @Override
        public boolean updatePlayer(Player player, PlayerProfile profile) {
            PotionEffect[] effects = profile.get(POTIONS);
            for (PotionEffect effect : player.getActivePotionEffects()) {
                player.removePotionEffect(effect.getType());
            }
            if (effects == null) {
                return false;
            }
            for (PotionEffect effect : effects) {
                player.addPotionEffect(effect);
            }
            return true;
        }
    }).serializer(new ProfileEntry(false, "potions"), new PotionEffectSerializer()).altName("potion").altName("potions").build();
    public static final SharableGroup ALL_INVENTORY = new SharableGroup("inventory", Sharables.fromSharables(INVENTORY, ARMOR, ENDER_CHEST, OFF_HAND), "inv", "inventories");
    public static final SharableGroup ALL_EXPERIENCE = new SharableGroup("experience", Sharables.fromSharables(EXPERIENCE, TOTAL_EXPERIENCE, LEVEL), "exp", "level");
    public static final SharableGroup AIR = new SharableGroup("air", Sharables.fromSharables(REMAINING_AIR, MAXIMUM_AIR), "breath");
    public static final SharableGroup HUNGER = new SharableGroup("hunger", Sharables.fromSharables(FOOD_LEVEL, SATURATION, EXHAUSTION), new String[0]);
    public static final SharableGroup ALL_HEALTH = new SharableGroup("health", Sharables.fromSharables(HEALTH, REMAINING_AIR, MAXIMUM_AIR, FALL_DISTANCE, FIRE_TICKS), new String[0]);
    public static final SharableGroup STATS = new SharableGroup("stats", Sharables.fromSharables(HEALTH, FOOD_LEVEL, SATURATION, EXHAUSTION, EXPERIENCE, TOTAL_EXPERIENCE, LEVEL, REMAINING_AIR, MAXIMUM_AIR, FALL_DISTANCE, FIRE_TICKS, POTIONS), new String[0]);
    public static final SharableGroup ALL_DEFAULT = new SharableGroup("all", Sharables.fromSharables(HEALTH, ECONOMY, FOOD_LEVEL, SATURATION, EXHAUSTION, EXPERIENCE, TOTAL_EXPERIENCE, LEVEL, INVENTORY, ARMOR, BED_SPAWN, MAXIMUM_AIR, REMAINING_AIR, FALL_DISTANCE, FIRE_TICKS, POTIONS, LAST_LOCATION, ENDER_CHEST, OFF_HAND), "*", "everything");
    private Set<Sharable> sharables;

    public static void init(MultiverseInventories inventories) {
        if (Sharables.inventories == null) {
            Sharables.inventories = inventories;
        }
    }

    static boolean register(Sharable sharable) {
        if (!ALL_SHARABLES.contains(sharable) && inventories != null) {
            for (WorldGroup group : inventories.getGroupManager().getGroups()) {
                if (!group.getShares().isSharing(Sharables.all())) continue;
                group.getShares().setSharing(sharable, true);
            }
        }
        if (ALL_SHARABLES.add(sharable)) {
            for (String name : sharable.getNames()) {
                String key = name.toLowerCase();
                Shares shares = LOOKUP_MAP.get(key);
                if (shares == null) {
                    shares = Sharables.noneOf();
                    LOOKUP_MAP.put(key, shares);
                }
                shares.add(sharable);
            }
            return true;
        }
        return false;
    }

    public static Shares lookup(String name) {
        return LOOKUP_MAP.get(name.toLowerCase());
    }

    public static Shares all() {
        return ALL_SHARABLES;
    }

    public static Shares allOf() {
        return new Sharables(new LinkedHashSet<Sharable>(ALL_SHARABLES));
    }

    public static Shares noneOf() {
        return new Sharables(new LinkedHashSet<Sharable>(ALL_SHARABLES.size()));
    }

    public static Shares complimentOf(Shares shares) {
        Shares compliment = Sharables.allOf();
        compliment.removeAll(shares);
        return new Sharables((Set<Sharable>)compliment);
    }

    public static Shares fromShares(Shares shares) {
        return new Sharables(shares);
    }

    public static Shares fromCollection(Collection<Sharable> sharesCollection) {
        Shares shares = Sharables.noneOf();
        shares.addAll(sharesCollection);
        return shares;
    }

    public static Shares fromSharables(Sharable ... sharables) {
        Shares shares = Sharables.noneOf();
        shares.addAll(Arrays.asList(sharables));
        return shares;
    }

    public static Shares negativeFromList(List sharesList) {
        Shares shares = Sharables.noneOf();
        for (Object shareStringObj : sharesList) {
            String shareString = shareStringObj.toString();
            if (!shareString.startsWith("-") || shareString.length() <= 1) continue;
            Shares sharables = Sharables.lookup(shareString = shareString.substring(1));
            if (sharables != null) {
                shares.mergeShares(sharables);
                continue;
            }
            if (!shareString.equals("*") && !shareString.equalsIgnoreCase("all") && !shareString.equalsIgnoreCase("everything")) continue;
            shares = Sharables.allOf();
            break;
        }
        return shares;
    }

    public static Shares fromList(List sharesList) {
        Shares shares = Sharables.noneOf();
        for (Object shareStringObj : sharesList) {
            String shareString = shareStringObj.toString();
            Shares sharables = Sharables.lookup(shareString);
            if (sharables != null) {
                shares.mergeShares(sharables);
                continue;
            }
            if (!shareString.equals("*") && !shareString.equalsIgnoreCase("all") && !shareString.equalsIgnoreCase("everything")) continue;
            shares = Sharables.allOf();
            break;
        }
        return shares;
    }

    private Sharables(Set<Sharable> sharableSet) {
        this.sharables = sharableSet;
    }

    private Sharables(Shares shares) {
        this.sharables = new LinkedHashSet<Sharable>(ALL_SHARABLES.size());
        this.sharables.addAll(shares);
    }

    @Override
    public int size() {
        return this.sharables.size();
    }

    @Override
    public boolean isEmpty() {
        return this.sharables.isEmpty();
    }

    @Override
    public boolean contains(Object o) {
        return this.sharables.contains(o);
    }

    @Override
    public Iterator<Sharable> iterator() {
        return this.sharables.iterator();
    }

    @Override
    public Object[] toArray() {
        return this.sharables.toArray();
    }

    @Override
    public <T> T[] toArray(T[] a) {
        return this.sharables.toArray(a);
    }

    @Override
    public boolean add(Sharable sharable) {
        return this.sharables.add(sharable);
    }

    @Override
    public boolean remove(Object o) {
        return this.sharables.remove(o);
    }

    @Override
    public boolean containsAll(Collection<?> c) {
        return this.sharables.containsAll(c);
    }

    @Override
    public boolean addAll(Collection<? extends Sharable> c) {
        return this.sharables.addAll(c);
    }

    @Override
    public boolean retainAll(Collection<?> c) {
        return this.sharables.retainAll(c);
    }

    @Override
    public boolean removeAll(Collection<?> c) {
        return this.sharables.removeAll(c);
    }

    @Override
    public void clear() {
        this.sharables.clear();
    }

    @Override
    public boolean equals(Object o) {
        return o instanceof Shares && ((Shares)o).isSharing(this);
    }

    @Override
    public int hashCode() {
        return this.sharables.hashCode();
    }

    @Override
    public void mergeShares(Shares newShares) {
        this.addAll(newShares);
    }

    @Override
    public void setSharing(Sharable sharable, boolean sharing) {
        if (sharing) {
            this.add(sharable);
        } else {
            this.remove(sharable);
        }
    }

    @Override
    public void setSharing(Shares sharables, boolean sharing) {
        for (Sharable sharable : sharables) {
            if (sharing) {
                this.add(sharable);
                continue;
            }
            this.remove(sharable);
        }
    }

    @Override
    public Shares compare(Shares shares) {
        Shares bothSharing = Sharables.noneOf();
        for (Sharable sharable : shares) {
            if (!this.contains(sharable)) continue;
            bothSharing.add(sharable);
        }
        return bothSharing;
    }

    @Override
    public boolean isSharing(Sharable sharable) {
        return this.contains(sharable);
    }

    @Override
    public boolean isSharing(Shares shares) {
        boolean isSharing = this.sharables.equals(shares);
        if (!isSharing) {
            for (Sharable sharable : shares) {
                if (this.isSharing(sharable)) continue;
                return false;
            }
            isSharing = true;
        }
        return isSharing;
    }

    @Override
    public List<String> toStringList() {
        LinkedList<String> list = new LinkedList<String>();
        if (this.isSharing(Sharables.allOf())) {
            list.add("all");
        } else {
            for (Sharable sharable : this) {
                list.add(sharable.toString());
            }
        }
        return list;
    }

    public String toString() {
        StringBuilder stringBuilder = new StringBuilder();
        for (Sharable sharable : this) {
            if (!stringBuilder.toString().isEmpty()) {
                stringBuilder.append(", ");
            }
            stringBuilder.append(sharable);
        }
        return stringBuilder.toString();
    }
}

