/*
 * Decompiled with CFR 0.152.
 */
package com.onarandombox.multiverseinventories.share;

import com.onarandombox.multiverseinventories.share.DefaultSerializer;
import com.onarandombox.multiverseinventories.share.DefaultSharable;
import com.onarandombox.multiverseinventories.share.DefaultStringSerializer;
import com.onarandombox.multiverseinventories.share.ProfileEntry;
import com.onarandombox.multiverseinventories.share.SharableHandler;
import com.onarandombox.multiverseinventories.share.SharableSerializer;
import java.util.ArrayList;
import java.util.List;

public interface Sharable<T> {
    public String[] getNames();

    public SharableHandler<T> getHandler();

    public SharableSerializer<T> getSerializer();

    public ProfileEntry getProfileEntry();

    public Class<T> getType();

    public boolean isOptional();

    public static class Builder<T> {
        private List<String> names = new ArrayList<String>();
        private ProfileEntry profileEntry = null;
        private SharableHandler<T> handler;
        private SharableSerializer<T> serializer = null;
        private boolean optional = false;
        private Class<T> type;

        public Builder(String name, Class<T> type, SharableHandler<T> handler) {
            this.names.add(name);
            this.handler = handler;
            this.type = type;
        }

        public Builder<T> optional() {
            this.optional = true;
            return this;
        }

        public Builder<T> altName(String name) {
            this.names.add(name);
            return this;
        }

        public Builder<T> stringSerializer(ProfileEntry entry) {
            this.serializer = new DefaultStringSerializer<T>(this.type);
            this.profileEntry = entry;
            return this;
        }

        public Builder<T> defaultSerializer(ProfileEntry entry) {
            this.serializer = new DefaultSerializer<T>(this.type);
            this.profileEntry = entry;
            return this;
        }

        public Builder<T> serializer(ProfileEntry entry, SharableSerializer<T> serializer) {
            this.serializer = serializer;
            this.profileEntry = entry;
            return this;
        }

        public Sharable<T> build() {
            DefaultSharable<T> sharable = new DefaultSharable<T>(this.names.toArray(new String[this.names.size()]), this.type, this.handler, this.serializer, this.profileEntry, this.optional);
            ProfileEntry.register(sharable);
            return sharable;
        }
    }
}

