/*
 * Decompiled with CFR 0.152.
 */
package com.onarandombox.multiverseinventories.share;

import com.onarandombox.multiverseinventories.share.Sharable;
import java.util.HashMap;
import java.util.Map;

public final class ProfileEntry {
    private static final Map<String, Sharable> STATS_MAP = new HashMap<String, Sharable>();
    private static final Map<String, Sharable> OTHERS_MAP = new HashMap<String, Sharable>();
    private boolean isStat;
    private String fileTag;

    public ProfileEntry(boolean isStat, String fileTag) {
        this.isStat = isStat;
        this.fileTag = fileTag;
    }

    public boolean isStat() {
        return this.isStat;
    }

    public String getFileTag() {
        return this.fileTag;
    }

    static void register(Sharable sharable) {
        ProfileEntry entry = sharable.getProfileEntry();
        if (entry == null) {
            return;
        }
        if (entry.isStat()) {
            STATS_MAP.put(entry.getFileTag(), sharable);
        } else {
            OTHERS_MAP.put(entry.getFileTag(), sharable);
        }
    }

    public static Sharable lookup(boolean stat, String fileTag) {
        if (stat) {
            return STATS_MAP.get(fileTag);
        }
        return OTHERS_MAP.get(fileTag);
    }
}

