/*
 * Decompiled with CFR 0.152.
 */
package com.onarandombox.multiverseinventories.share;

import com.onarandombox.multiverseinventories.share.SharableSerializer;
import com.onarandombox.multiverseinventories.util.MinecraftTools;
import java.util.HashMap;
import java.util.Map;
import org.bukkit.Material;
import org.bukkit.inventory.ItemStack;

public final class InventorySerializer
implements SharableSerializer<ItemStack[]> {
    private int inventorySize;

    public InventorySerializer(int inventorySize) {
        this.inventorySize = inventorySize;
    }

    @Override
    public ItemStack[] deserialize(Object obj) {
        return this.unmapSlots(obj);
    }

    @Override
    public Object serialize(ItemStack[] itemStacks) {
        return this.mapSlots(itemStacks);
    }

    private Map<String, ItemStack> mapSlots(ItemStack[] itemStacks) {
        HashMap<String, ItemStack> result = new HashMap<String, ItemStack>(itemStacks.length);
        for (int i = 0; i < itemStacks.length; ++i) {
            if (itemStacks[i] == null || itemStacks[i].getType() == Material.AIR) continue;
            result.put(Integer.toString(i), itemStacks[i]);
        }
        return result;
    }

    private ItemStack[] unmapSlots(Object obj) {
        ItemStack[] result = new ItemStack[this.inventorySize];
        if (obj instanceof Map) {
            Map invMap = (Map)obj;
            for (int i = 0; i < result.length; ++i) {
                Object value = invMap.get(Integer.toString(i));
                result[i] = value != null && value instanceof ItemStack ? (ItemStack)value : new ItemStack(Material.AIR);
            }
            return result;
        }
        return MinecraftTools.fillWithAir(result);
    }
}

