/*
 * Decompiled with CFR 0.152.
 */
package com.onarandombox.multiverseinventories.share;

import com.onarandombox.multiverseinventories.share.SharableSerializer;
import com.onarandombox.multiverseinventories.utils.InvLogging;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;

final class DefaultStringSerializer<T>
implements SharableSerializer<T> {
    private Method valueOfMethod;
    private Class<T> clazz;

    DefaultStringSerializer(Class<T> clazz) {
        this.clazz = clazz;
        try {
            this.valueOfMethod = clazz.getMethod("valueOf", String.class);
            this.valueOfMethod.setAccessible(true);
            if (!this.valueOfMethod.getReturnType().equals(clazz) || !Modifier.isStatic(this.valueOfMethod.getModifiers())) {
                throw new IllegalArgumentException(clazz.getName() + " has no static valueOf(String) method!");
            }
        }
        catch (NoSuchMethodException e) {
            throw new IllegalArgumentException(clazz.getName() + " has no static valueOf(String) method!");
        }
    }

    @Override
    public T deserialize(Object obj) {
        try {
            return this.clazz.cast(this.valueOfMethod.invoke(null, obj.toString()));
        }
        catch (IllegalAccessException e) {
            InvLogging.severe(this.clazz.getName() + " has no accessible static valueOf(String) method!", new Object[0]);
        }
        catch (InvocationTargetException e) {
            InvLogging.severe(this.clazz.getName() + ".valueOf(String) is throwing an exception:", new Object[0]);
            e.printStackTrace();
        }
        throw new IllegalStateException(this.getClass().getName() + " was used illegally!  Contact dumptruckman!");
    }

    @Override
    public Object serialize(T t) {
        return t.toString();
    }
}

