/*
 * Decompiled with CFR 0.152.
 */
package com.onarandombox.multiverseinventories.profile;

import com.google.common.base.Objects;
import com.onarandombox.multiverseinventories.profile.ProfileType;
import com.onarandombox.multiverseinventories.profile.container.ContainerType;
import java.util.UUID;
import org.bukkit.Bukkit;

public final class ProfileKey {
    private final ContainerType containerType;
    private final String dataName;
    private final ProfileType profileType;
    private final String playerName;
    private final UUID playerUUID;

    public static ProfileKey createProfileKey(ContainerType containerType, String dataName, ProfileType profileType, UUID playerUUID, String playerName) {
        return new ProfileKey(containerType, dataName, profileType, playerUUID, playerName);
    }

    public static ProfileKey createProfileKey(ContainerType containerType, String dataName, ProfileType profileType, UUID playerUUID) {
        return new ProfileKey(containerType, dataName, profileType, playerUUID);
    }

    public static ProfileKey createProfileKey(ProfileKey copyKey, ContainerType containerType) {
        return new ProfileKey(containerType, copyKey.getDataName(), copyKey.getProfileType(), copyKey.getPlayerUUID(), copyKey.getPlayerName());
    }

    public static ProfileKey createProfileKey(ProfileKey copyKey, ProfileType profileType) {
        return new ProfileKey(copyKey.getContainerType(), copyKey.getDataName(), profileType, copyKey.getPlayerUUID(), copyKey.getPlayerName());
    }

    public static ProfileKey createProfileKey(ProfileKey copyKey, ContainerType containerType, ProfileType profileType) {
        return new ProfileKey(containerType, copyKey.getDataName(), profileType, copyKey.getPlayerUUID(), copyKey.getPlayerName());
    }

    private ProfileKey(ContainerType containerType, String dataName, ProfileType profileType, UUID playerUUID) {
        this.containerType = containerType;
        this.dataName = dataName;
        this.profileType = profileType;
        this.playerUUID = playerUUID;
        this.playerName = Bukkit.getOfflinePlayer((UUID)playerUUID).getName();
    }

    private ProfileKey(ContainerType containerType, String dataName, ProfileType profileType, UUID playerUUID, String playerName) {
        this.containerType = containerType;
        this.dataName = dataName;
        this.profileType = profileType;
        this.playerUUID = playerUUID;
        this.playerName = playerName;
    }

    public ContainerType getContainerType() {
        return this.containerType;
    }

    public String getDataName() {
        return this.dataName;
    }

    public ProfileType getProfileType() {
        return this.profileType;
    }

    public String getPlayerName() {
        return this.playerName;
    }

    public UUID getPlayerUUID() {
        return this.playerUUID;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof ProfileKey)) {
            return false;
        }
        ProfileKey that = (ProfileKey)o;
        return this.getContainerType() == that.getContainerType() && Objects.equal((Object)this.getDataName(), (Object)that.getDataName()) && Objects.equal((Object)this.getProfileType(), (Object)that.getProfileType()) && Objects.equal((Object)this.getPlayerName(), (Object)that.getPlayerName()) && Objects.equal((Object)this.getPlayerUUID(), (Object)that.getPlayerUUID());
    }

    public int hashCode() {
        return Objects.hashCode((Object[])new Object[]{this.getContainerType(), this.getDataName(), this.getProfileType(), this.getPlayerName(), this.getPlayerUUID()});
    }

    public String toString() {
        return "ProfileKey{containerType=" + (Object)((Object)this.containerType) + ", dataName='" + this.dataName + '\'' + ", profileType=" + this.profileType + ", playerName='" + this.playerName + '\'' + ", playerUUID=" + this.playerUUID + '}';
    }
}

