/*
 * Decompiled with CFR 0.152.
 */
package com.onarandombox.multiverseinventories.profile;

import com.onarandombox.multiverseinventories.profile.ProfileType;
import com.onarandombox.multiverseinventories.profile.container.ContainerType;
import com.onarandombox.multiverseinventories.share.Sharable;
import com.onarandombox.multiverseinventories.share.SharableEntry;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import org.bukkit.Bukkit;
import org.bukkit.OfflinePlayer;

public final class PlayerProfile
implements Cloneable,
Iterable<SharableEntry> {
    private Map<Sharable, SharableEntry> data = new HashMap<Sharable, SharableEntry>();
    private final OfflinePlayer player;
    private final ContainerType containerType;
    private final String containerName;
    private final ProfileType profileType;

    public static PlayerProfile createPlayerProfile(ContainerType containerType, String containerName, ProfileType profileType, OfflinePlayer player) {
        return new PlayerProfile(containerType, containerName, profileType, player);
    }

    @Deprecated
    public static PlayerProfile createPlayerProfile(ContainerType containerType, String containerName, ProfileType profileType, String playerName) {
        return new PlayerProfile(containerType, containerName, profileType, Bukkit.getOfflinePlayer((String)playerName));
    }

    private PlayerProfile(ContainerType containerType, String containerName, ProfileType profileType, OfflinePlayer player) {
        this.containerType = containerType;
        this.profileType = profileType;
        this.containerName = containerName;
        this.player = player;
    }

    public ContainerType getContainerType() {
        return this.containerType;
    }

    public String getContainerName() {
        return this.containerName;
    }

    public OfflinePlayer getPlayer() {
        return this.player;
    }

    public ProfileType getProfileType() {
        return this.profileType;
    }

    public <T> T get(Sharable<T> sharable) {
        SharableEntry entry = this.data.get(sharable);
        return sharable.getType().cast(entry != null ? entry.getValue() : null);
    }

    public <T> void set(Sharable<T> sharable, T value) {
        this.data.put(sharable, new SharableEntry<T>(sharable, value));
    }

    public PlayerProfile clone() {
        try {
            return (PlayerProfile)super.clone();
        }
        catch (CloneNotSupportedException e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    public Iterator<SharableEntry> iterator() {
        return new SharablesIterator(this.data.values().iterator());
    }

    private static class SharablesIterator
    implements Iterator<SharableEntry> {
        private final Iterator<SharableEntry> backingIterator;

        private SharablesIterator(Iterator<SharableEntry> backingIterator) {
            this.backingIterator = backingIterator;
        }

        @Override
        public boolean hasNext() {
            return this.backingIterator.hasNext();
        }

        @Override
        public SharableEntry next() {
            return this.backingIterator.next();
        }

        @Override
        public void remove() {
            throw new UnsupportedOperationException();
        }
    }
}

