/*
 * Decompiled with CFR 0.152.
 */
package com.onarandombox.multiverseinventories.profile;

import com.onarandombox.multiverseinventories.WorldGroup;
import com.onarandombox.multiverseinventories.share.Shares;
import java.util.ArrayList;
import java.util.List;

public final class GroupingConflict {
    private WorldGroup groupOne;
    private WorldGroup groupTwo;
    private Shares conflictingShares;

    public GroupingConflict(WorldGroup groupOne, WorldGroup groupTwo, Shares conflictingShares) {
        this.groupOne = groupOne;
        this.groupTwo = groupTwo;
        this.conflictingShares = conflictingShares;
    }

    public WorldGroup getFirstGroup() {
        return this.groupOne;
    }

    public WorldGroup getSecondGroup() {
        return this.groupTwo;
    }

    public Shares getConflictingShares() {
        return this.conflictingShares;
    }

    public List<String> getConflictingWorlds() {
        ArrayList<String> worlds = new ArrayList<String>();
        for (String world : this.getFirstGroup().getWorlds()) {
            if (!this.getSecondGroup().getWorlds().contains(world)) continue;
            worlds.add(world);
        }
        return worlds;
    }

    public String getWorldsString() {
        StringBuilder builder = new StringBuilder();
        for (String world : this.getConflictingWorlds()) {
            if (!builder.toString().isEmpty()) {
                builder.append(", ");
            }
            builder.append(world);
        }
        return builder.toString();
    }
}

