/*
 * Decompiled with CFR 0.152.
 */
package com.onarandombox.multiverseinventories.migration.multiinv;

import com.onarandombox.multiverseinventories.MultiverseInventories;
import com.onarandombox.multiverseinventories.WorldGroup;
import com.onarandombox.multiverseinventories.migration.DataImporter;
import com.onarandombox.multiverseinventories.migration.MigrationException;
import com.onarandombox.multiverseinventories.migration.multiinv.MIInventoryInterface;
import com.onarandombox.multiverseinventories.migration.multiinv.MIPlayerFileLoader;
import com.onarandombox.multiverseinventories.profile.PlayerProfile;
import com.onarandombox.multiverseinventories.profile.ProfileTypes;
import com.onarandombox.multiverseinventories.profile.container.ContainerType;
import com.onarandombox.multiverseinventories.share.Sharables;
import com.onarandombox.multiverseinventories.utils.InvLogging;
import java.lang.reflect.Field;
import java.util.HashMap;
import java.util.Map;
import org.bukkit.Bukkit;
import org.bukkit.GameMode;
import org.bukkit.OfflinePlayer;
import org.bukkit.World;
import org.bukkit.plugin.Plugin;
import uk.co.tggl.pluckerpluck.multiinv.MIYamlFiles;
import uk.co.tggl.pluckerpluck.multiinv.MultiInv;

public class MultiInvImporter
implements DataImporter {
    private MultiInv miPlugin;
    private MultiverseInventories inventories;

    public MultiInvImporter(MultiverseInventories inventories, MultiInv miPlugin) {
        this.inventories = inventories;
        this.miPlugin = miPlugin;
    }

    public MultiInv getMIPlugin() {
        return this.miPlugin;
    }

    @Override
    public Plugin getPlugin() {
        return this.getMIPlugin();
    }

    @Override
    public void importData() throws MigrationException {
        WorldGroup defaultWorldGroup;
        HashMap<String, String> miGroupMap = this.getGroupMap();
        if (miGroupMap == null) {
            throw new MigrationException("There is no data to import from MultiInv!");
        }
        if (!miGroupMap.isEmpty() && (defaultWorldGroup = this.inventories.getGroupManager().getDefaultGroup()) != null) {
            this.inventories.getGroupManager().removeGroup(defaultWorldGroup);
            InvLogging.info("Removed automatically created world group in favor of imported groups.", new Object[0]);
        }
        for (Map.Entry<String, String> groupEntry : miGroupMap.entrySet()) {
            WorldGroup worldGroup = this.inventories.getGroupManager().getGroup(groupEntry.getValue());
            if (worldGroup == null) {
                worldGroup = this.inventories.getGroupManager().newEmptyGroup(groupEntry.getValue());
                worldGroup.getShares().mergeShares(Sharables.allOf());
                InvLogging.info("Importing group: " + groupEntry.getValue(), new Object[0]);
                this.inventories.getGroupManager().updateGroup(worldGroup);
            }
            worldGroup.addWorld(groupEntry.getValue());
        }
        this.inventories.getMVIConfig().save();
        for (OfflinePlayer player : Bukkit.getServer().getOfflinePlayers()) {
            String worldName;
            InvLogging.info("Processing MultiInv data for player: " + player.getName(), new Object[0]);
            for (Map.Entry<String, String> entry : miGroupMap.entrySet()) {
                worldName = entry.getKey();
                String groupName = entry.getValue();
                MIPlayerFileLoader playerFileLoader = new MIPlayerFileLoader(this.getMIPlugin(), player, groupName);
                if (!playerFileLoader.load()) continue;
                InvLogging.info("Processing MultiInv data for player: " + player.getName() + " for group: " + groupName, new Object[0]);
                this.mergeData(player, playerFileLoader, groupName, ContainerType.GROUP);
            }
            for (World world : Bukkit.getWorlds()) {
                worldName = world.getName();
                MIPlayerFileLoader playerFileLoader = new MIPlayerFileLoader(this.getMIPlugin(), player, worldName);
                if (!playerFileLoader.load()) continue;
                InvLogging.info("Processing MultiInv data for player: " + player.getName() + " for world only: " + worldName, new Object[0]);
                this.mergeData(player, playerFileLoader, worldName, ContainerType.WORLD);
            }
        }
        InvLogging.info("Import from MultiInv finished.  Disabling MultiInv.", new Object[0]);
        Bukkit.getPluginManager().disablePlugin((Plugin)this.getMIPlugin());
    }

    private void mergeData(OfflinePlayer player, MIPlayerFileLoader playerFileLoader, String dataName, ContainerType type) {
        PlayerProfile playerProfile;
        if (type.equals((Object)ContainerType.GROUP)) {
            WorldGroup group = this.inventories.getGroupManager().getGroup(dataName);
            if (group == null) {
                InvLogging.warning("Could not import player data for group: " + dataName, new Object[0]);
                return;
            }
            playerProfile = group.getGroupProfileContainer().getPlayerData(ProfileTypes.SURVIVAL, player);
        } else {
            playerProfile = this.inventories.getWorldProfileContainerStore().getContainer(dataName).getPlayerData(ProfileTypes.SURVIVAL, player);
        }
        MIInventoryInterface inventoryInterface = playerFileLoader.getInventory(GameMode.SURVIVAL.toString());
        playerProfile.set(Sharables.INVENTORY, inventoryInterface.getInventoryContents());
        playerProfile.set(Sharables.ARMOR, inventoryInterface.getArmorContents());
        playerProfile.set(Sharables.HEALTH, playerFileLoader.getHealth());
        playerProfile.set(Sharables.SATURATION, Float.valueOf(playerFileLoader.getSaturation()));
        playerProfile.set(Sharables.EXPERIENCE, Float.valueOf(playerFileLoader.getExperience()));
        playerProfile.set(Sharables.TOTAL_EXPERIENCE, playerFileLoader.getTotalExperience());
        playerProfile.set(Sharables.LEVEL, playerFileLoader.getLevel());
        playerProfile.set(Sharables.FOOD_LEVEL, playerFileLoader.getHunger());
        this.inventories.getData().updatePlayerData(playerProfile);
    }

    private HashMap<String, String> getGroupMap() throws MigrationException {
        Field field;
        try {
            field = MIYamlFiles.class.getDeclaredField("groups");
        }
        catch (NoSuchFieldException nsfe) {
            throw new MigrationException("The running version of MultiInv is incompatible with the import feature.").setCauseException(nsfe);
        }
        field.setAccessible(true);
        HashMap miGroupMap = null;
        try {
            miGroupMap = (HashMap)field.get(null);
        }
        catch (IllegalAccessException iae) {
            throw new MigrationException("The running version of MultiInv is incompatible with the import feature.").setCauseException(iae);
        }
        catch (ClassCastException cce) {
            throw new MigrationException("The running version of MultiInv is incompatible with the import feature.").setCauseException(cce);
        }
        return miGroupMap;
    }
}

