/*
 * Decompiled with CFR 0.152.
 */
package com.onarandombox.multiverseinventories.command.prompts;

import com.onarandombox.multiverseinventories.MultiverseInventories;
import com.onarandombox.multiverseinventories.WorldGroup;
import com.onarandombox.multiverseinventories.command.prompts.InventoriesPrompt;
import com.onarandombox.multiverseinventories.locale.Message;
import java.util.HashSet;
import java.util.Set;
import org.bukkit.Bukkit;
import org.bukkit.ChatColor;
import org.bukkit.World;
import org.bukkit.command.CommandSender;
import org.bukkit.conversations.ConversationContext;
import org.bukkit.conversations.Prompt;

class GroupWorldsPrompt
extends InventoriesPrompt {
    protected final WorldGroup group;
    protected final Prompt nextPrompt;
    protected final boolean isCreating;
    protected final Set<String> worlds;

    public GroupWorldsPrompt(MultiverseInventories plugin, CommandSender sender, WorldGroup group, Prompt nextPrompt, boolean creatingGroup) {
        super(plugin, sender);
        this.group = group;
        this.nextPrompt = nextPrompt;
        this.isCreating = creatingGroup;
        this.worlds = new HashSet<String>(group.getWorlds());
    }

    public String getPromptText(ConversationContext conversationContext) {
        StringBuilder builder = new StringBuilder();
        for (String world : this.worlds) {
            if (builder.length() == 0) {
                builder.append(ChatColor.WHITE);
            } else {
                builder.append(ChatColor.GOLD).append(", ").append(ChatColor.WHITE);
            }
            builder.append(world);
        }
        return this.messager.getMessage(Message.GROUP_WORLDS_PROMPT, this.group.getName(), builder.toString());
    }

    public Prompt acceptInput(ConversationContext conversationContext, String s) {
        World world;
        boolean negative;
        if (s.equals("@")) {
            if (this.worlds.isEmpty()) {
                this.messager.normal(Message.GROUP_WORLDS_EMPTY, this.sender, new Object[0]);
                return this;
            }
            this.group.getWorlds().clear();
            this.group.getWorlds().addAll(this.worlds);
            if (!this.isCreating) {
                this.plugin.getGroupManager().updateGroup(this.group);
                this.messager.normal(Message.GROUP_UPDATED, this.sender, new Object[0]);
                this.messager.normal(Message.INFO_GROUP, this.sender, this.group.getName());
                this.messager.normal(Message.INFO_GROUPS_INFO, this.sender, this.group.getWorlds(), this.group.getShares());
            }
            return this.nextPrompt;
        }
        if (s.startsWith("-") && s.length() > 1) {
            negative = true;
            world = Bukkit.getWorld((String)s.substring(1));
        } else {
            negative = false;
            world = Bukkit.getWorld((String)s);
        }
        if (world == null) {
            this.messager.normal(Message.ERROR_NO_WORLD, this.sender, s);
        } else if (negative) {
            if (!this.worlds.contains(world.getName())) {
                this.messager.normal(Message.WORLD_NOT_IN_GROUP, this.sender, world.getName(), this.group.getName());
                return this;
            }
            this.worlds.remove(world.getName());
        } else {
            this.worlds.add(world.getName());
        }
        return this;
    }
}

