/*
 * Decompiled with CFR 0.152.
 */
package com.onarandombox.multiverseinventories.command.prompts;

import com.onarandombox.multiverseinventories.MultiverseInventories;
import com.onarandombox.multiverseinventories.WorldGroup;
import com.onarandombox.multiverseinventories.command.prompts.InventoriesPrompt;
import com.onarandombox.multiverseinventories.locale.Message;
import com.onarandombox.multiverseinventories.share.Sharable;
import com.onarandombox.multiverseinventories.share.Sharables;
import com.onarandombox.multiverseinventories.share.Shares;
import org.bukkit.ChatColor;
import org.bukkit.command.CommandSender;
import org.bukkit.conversations.ConversationContext;
import org.bukkit.conversations.Prompt;

class GroupSharesPrompt
extends InventoriesPrompt {
    protected final WorldGroup group;
    protected final Prompt nextPrompt;
    protected final boolean isCreating;
    protected final Shares shares;

    public GroupSharesPrompt(MultiverseInventories plugin, CommandSender sender, WorldGroup group, Prompt nextPrompt, boolean creatingGroup) {
        super(plugin, sender);
        this.group = group;
        this.nextPrompt = nextPrompt;
        this.isCreating = creatingGroup;
        this.shares = Sharables.fromShares(group.getShares());
    }

    public String getPromptText(ConversationContext conversationContext) {
        StringBuilder builder = new StringBuilder();
        for (Sharable sharable : this.shares) {
            if (builder.length() == 0) {
                builder.append(ChatColor.WHITE);
            } else {
                builder.append(ChatColor.GOLD).append(", ").append(ChatColor.WHITE);
            }
            builder.append(sharable.toString());
        }
        return this.messager.getMessage(Message.GROUP_SHARES_PROMPT, this.group.getName(), builder.toString());
    }

    public Prompt acceptInput(ConversationContext conversationContext, String s) {
        Shares shares;
        if (s.equals("@")) {
            this.group.getShares().clear();
            this.group.getShares().addAll(this.shares);
            this.plugin.getGroupManager().updateGroup(this.group);
            if (this.isCreating) {
                this.messager.normal(Message.GROUP_CREATION_COMPLETE, this.sender, new Object[0]);
            } else {
                this.messager.normal(Message.GROUP_UPDATED, this.sender, new Object[0]);
            }
            this.messager.normal(Message.INFO_GROUP, this.sender, this.group.getName());
            this.messager.normal(Message.INFO_GROUPS_INFO, this.sender, this.group.getWorlds(), this.group.getShares());
            this.plugin.getGroupManager().checkForConflicts(this.sender);
            return this.nextPrompt;
        }
        boolean negative = false;
        if (s.startsWith("-") && s.length() > 1) {
            negative = true;
            shares = Sharables.lookup(s.toLowerCase().substring(1));
        } else {
            shares = Sharables.lookup(s.toLowerCase());
        }
        if (shares == null) {
            this.messager.normal(Message.ERROR_NO_SHARES_SPECIFIED, this.sender, new Object[0]);
        } else if (!negative) {
            this.shares.addAll(shares);
        } else {
            this.shares.removeAll(shares);
        }
        return this;
    }
}

