/*
 * Decompiled with CFR 0.152.
 */
package com.onarandombox.multiverseinventories.command.prompts;

import com.onarandombox.multiverseinventories.MultiverseInventories;
import com.onarandombox.multiverseinventories.WorldGroup;
import com.onarandombox.multiverseinventories.command.prompts.GroupSharesPrompt;
import com.onarandombox.multiverseinventories.command.prompts.GroupWorldsPrompt;
import com.onarandombox.multiverseinventories.command.prompts.InventoriesPrompt;
import com.onarandombox.multiverseinventories.locale.Message;
import org.bukkit.command.CommandSender;
import org.bukkit.conversations.ConversationContext;
import org.bukkit.conversations.Prompt;

class GroupCreatePrompt
extends InventoriesPrompt {
    public GroupCreatePrompt(MultiverseInventories plugin, CommandSender sender) {
        super(plugin, sender);
    }

    public String getPromptText(ConversationContext conversationContext) {
        return this.messager.getMessage(Message.GROUP_CREATE_PROMPT, new Object[0]);
    }

    public Prompt acceptInput(ConversationContext conversationContext, String s) {
        WorldGroup group = this.plugin.getGroupManager().getGroup(s);
        if (group == null) {
            if (s.isEmpty() || !s.matches("^[a-zA-Z0-9][a-zA-Z0-9_]*$")) {
                this.messager.normal(Message.GROUP_INVALID_NAME, this.sender, new Object[0]);
                return this;
            }
            WorldGroup newGroup = this.plugin.getGroupManager().newEmptyGroup(s);
            return new GroupWorldsPrompt(this.plugin, this.sender, newGroup, new GroupSharesPrompt(this.plugin, this.sender, newGroup, Prompt.END_OF_CONVERSATION, true), true);
        }
        this.messager.normal(Message.GROUP_EXISTS, this.sender, s);
        return Prompt.END_OF_CONVERSATION;
    }
}

