/*
 * Decompiled with CFR 0.152.
 */
package com.onarandombox.multiverseinventories.command;

import com.onarandombox.MultiverseCore.api.MultiverseWorld;
import com.onarandombox.multiverseinventories.MultiverseInventories;
import com.onarandombox.multiverseinventories.WorldGroup;
import com.onarandombox.multiverseinventories.command.InventoriesCommand;
import com.onarandombox.multiverseinventories.locale.Message;
import com.onarandombox.multiverseinventories.util.Perm;
import java.util.List;
import org.bukkit.Bukkit;
import org.bukkit.ChatColor;
import org.bukkit.Location;
import org.bukkit.World;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Entity;
import org.bukkit.entity.Player;

public class SpawnCommand
extends InventoriesCommand {
    public SpawnCommand(MultiverseInventories plugin) {
        super(plugin);
        this.setName("Spawn");
        this.setCommandUsage("/mvinv spawn" + ChatColor.GOLD + " [PLAYER]");
        this.setArgRange(0, 1);
        this.addKey("mvinv spawn");
        this.addKey("mvinvspawn");
        this.addKey("mvinvs");
        this.addKey("gspawn");
        this.addKey("ispawn");
        this.setPermission(Perm.COMMAND_SPAWN.getPermission());
        this.addAdditonalPermission(Perm.COMMAND_SPAWN_OTHER.getPermission());
    }

    @Override
    public void runCommand(CommandSender sender, List<String> args) {
        Player player = null;
        if (sender instanceof Player) {
            player = (Player)sender;
        }
        if (args.size() == 1) {
            Perm perm = Perm.COMMAND_SPAWN_OTHER;
            if (player != null && !perm.has((CommandSender)player)) {
                this.messager.normal(Message.GENERIC_COMMAND_NO_PERMISSION, (CommandSender)player, perm.getPermission().getDescription(), perm.getPermission().getName());
                return;
            }
            Player target = Bukkit.getPlayerExact((String)args.get(0));
            if (target != null) {
                this.messager.normal(Message.TELEPORTING, (CommandSender)target, new Object[0]);
                this.spawnAccurately(target);
                if (player != null) {
                    this.messager.normal(Message.TELEPORTED_BY, (CommandSender)target, ChatColor.YELLOW + player.getName());
                } else {
                    this.messager.normal(Message.TELEPORTED_BY, (CommandSender)target, ChatColor.LIGHT_PURPLE + this.messager.getMessage(Message.GENERIC_THE_CONSOLE, new Object[0]));
                }
            } else {
                this.messager.normal(Message.GENERIC_NOT_LOGGED_IN, sender, args.get(0));
            }
        } else {
            Perm perm = Perm.COMMAND_SPAWN;
            if (player != null && !perm.has((CommandSender)player)) {
                this.messager.normal(Message.GENERIC_COMMAND_NO_PERMISSION, (CommandSender)player, perm.getPermission().getDescription(), perm.getPermission().getName());
                return;
            }
            if (player != null) {
                this.messager.normal(Message.TELEPORTING, (CommandSender)player, new Object[0]);
                this.spawnAccurately(player);
            } else {
                this.messager.normal(Message.TELEPORT_CONSOLE_ERROR, sender, new Object[0]);
            }
        }
    }

    private void spawnAccurately(Player player) {
        MultiverseWorld mvWorld;
        World world = null;
        for (WorldGroup group : this.plugin.getGroupManager().getGroupsForWorld(player.getWorld().getName())) {
            if (group.getSpawnWorld() != null && (world = Bukkit.getWorld((String)group.getSpawnWorld())) != null) break;
        }
        if (world == null) {
            world = player.getWorld();
        }
        Location spawnLocation = (mvWorld = this.plugin.getCore().getMVWorldManager().getMVWorld(world)) != null ? mvWorld.getSpawnLocation() : world.getSpawnLocation();
        this.plugin.getCore().getSafeTTeleporter().safelyTeleport((CommandSender)player, (Entity)player, spawnLocation, false);
    }
}

