/*
 * Decompiled with CFR 0.152.
 */
package com.onarandombox.multiverseinventories;

import com.google.common.collect.Lists;
import com.onarandombox.multiverseinventories.AbstractWorldGroupManager;
import com.onarandombox.multiverseinventories.MultiverseInventories;
import com.onarandombox.multiverseinventories.WorldGroup;
import com.onarandombox.multiverseinventories.share.Sharables;
import com.onarandombox.multiverseinventories.util.CommentedYamlConfiguration;
import com.onarandombox.multiverseinventories.util.DeserializationException;
import com.onarandombox.multiverseinventories.utils.InvLogging;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.bukkit.Bukkit;
import org.bukkit.World;
import org.bukkit.configuration.Configuration;
import org.bukkit.configuration.ConfigurationSection;
import org.bukkit.configuration.file.FileConfiguration;
import org.bukkit.event.EventPriority;

final class YamlWorldGroupManager
extends AbstractWorldGroupManager {
    private final List<String> groupSectionComments = Collections.unmodifiableList(new ArrayList<String>(){
        {
            this.add("# To ADD, DELETE, and EDIT groups use the command /mvinv group.");
            this.add("# No support will be given for those who manually edit these groups.");
        }
    });
    private final CommentedYamlConfiguration groupsConfig;

    YamlWorldGroupManager(MultiverseInventories inventories, File groupConfigFile, Configuration config) throws IOException {
        super(inventories);
        boolean migrateGroups = false;
        if (!groupConfigFile.exists()) {
            InvLogging.fine("Created groups file.", new Object[0]);
            groupConfigFile.createNewFile();
            migrateGroups = true;
        }
        this.groupsConfig = new CommentedYamlConfiguration(groupConfigFile, true);
        this.groupsConfig.load();
        if (migrateGroups) {
            this.migrateGroups(config);
        }
        this.groupsConfig.addComment("groups", this.groupSectionComments);
        if (this.groupsConfig.getConfig().get("groups") == null) {
            this.getConfig().createSection("groups");
        }
        this.groupsConfig.getConfig().options().header("# Multiverse-Inventories Groups");
        this.groupsConfig.save();
        List<WorldGroup> worldGroups = this.getGroupsFromConfig();
        if (worldGroups == null) {
            InvLogging.info("No world groups have been configured!", new Object[0]);
            InvLogging.info("This will cause all worlds configured for Multiverse to have separate player statistics/inventories.", new Object[0]);
            return;
        }
        for (WorldGroup worldGroup : worldGroups) {
            this.getGroupNames().put(worldGroup.getName().toLowerCase(), worldGroup);
        }
    }

    private void migrateGroups(Configuration config) {
        if (config == null) {
            return;
        }
        ConfigurationSection section = config.getConfigurationSection("groups");
        if (section != null) {
            this.getConfig().set("groups", (Object)section);
            config.set("groups", null);
            InvLogging.fine("Migrated groups to groups.yml", new Object[0]);
        }
    }

    private FileConfiguration getConfig() {
        return this.groupsConfig.getConfig();
    }

    private List<WorldGroup> getGroupsFromConfig() {
        InvLogging.finer("Getting world groups from config file", new Object[0]);
        ConfigurationSection groupsSection = this.getConfig().getConfigurationSection("groups");
        if (groupsSection == null) {
            InvLogging.finer("Could not find a 'groups' section in config!", new Object[0]);
            return null;
        }
        Set groupNames = groupsSection.getKeys(false);
        InvLogging.finer("Loading groups: " + groupNames.toString(), new Object[0]);
        ArrayList<WorldGroup> worldGroups = new ArrayList<WorldGroup>(groupNames.size());
        for (String groupName : groupNames) {
            WorldGroup worldGroup;
            InvLogging.finer("Attempting to load group: " + groupName + "...", new Object[0]);
            try {
                ConfigurationSection groupSection = this.getConfig().getConfigurationSection("groups." + groupName);
                if (groupSection == null) {
                    InvLogging.warning("Group: '" + groupName + "' is not formatted correctly!", new Object[0]);
                    continue;
                }
                worldGroup = this.deserializeGroup(groupName, groupSection.getValues(true));
            }
            catch (DeserializationException e) {
                InvLogging.warning("Unable to load world group: " + groupName, new Object[0]);
                InvLogging.warning("Reason: " + e.getMessage(), new Object[0]);
                continue;
            }
            worldGroups.add(worldGroup);
            InvLogging.finer("Group: " + worldGroup.getName() + " added to memory", new Object[0]);
        }
        return worldGroups;
    }

    private WorldGroup deserializeGroup(String name, Map<String, Object> dataMap) throws DeserializationException {
        WorldGroup profile = new WorldGroup(this.plugin, name);
        if (dataMap.containsKey("worlds")) {
            Object worldListObj = dataMap.get("worlds");
            if (worldListObj == null) {
                InvLogging.fine("No worlds for group: " + name, new Object[0]);
            } else if (!(worldListObj instanceof List)) {
                InvLogging.fine("World list formatted incorrectly for world group: " + name, new Object[0]);
            } else {
                StringBuilder builder = new StringBuilder();
                for (Object worldNameObj : (List)worldListObj) {
                    if (worldNameObj == null) {
                        InvLogging.fine("Error with a world listed in group: " + name, new Object[0]);
                        continue;
                    }
                    profile.addWorld(worldNameObj.toString(), false);
                    World world = Bukkit.getWorld((String)worldNameObj.toString());
                    if (world != null) continue;
                    if (builder.length() != 0) {
                        builder.append(", ");
                    }
                    builder.append(worldNameObj.toString());
                }
                if (builder.length() > 0) {
                    InvLogging.config("The following worlds for group '%s' are not loaded: %s", name, builder.toString());
                }
            }
        }
        if (dataMap.containsKey("shares")) {
            Object sharesListObj = dataMap.get("shares");
            if (sharesListObj instanceof List) {
                profile.getShares().mergeShares(Sharables.fromList((List)sharesListObj));
                profile.getShares().removeAll(Sharables.negativeFromList((List)sharesListObj));
            } else {
                InvLogging.warning("Shares formatted incorrectly for group: " + name, new Object[0]);
            }
        }
        if (dataMap.containsKey("spawn")) {
            Object spawnPropsObj = dataMap.get("spawn");
            if (spawnPropsObj instanceof ConfigurationSection) {
                spawnPropsObj = ((ConfigurationSection)spawnPropsObj).getValues(true);
            }
            if (spawnPropsObj instanceof Map) {
                EventPriority priority;
                Map spawnProps = (Map)spawnPropsObj;
                if (spawnProps.containsKey("world")) {
                    profile.setSpawnWorld(spawnProps.get("world").toString());
                }
                if (spawnProps.containsKey("priority") && (priority = EventPriority.valueOf((String)spawnProps.get("priority").toString().toUpperCase())) != null) {
                    profile.setSpawnPriority(priority);
                }
            } else {
                InvLogging.warning("Spawn settings for group formatted incorrectly", new Object[0]);
            }
        }
        return profile;
    }

    private void updateWorldGroup(WorldGroup worldGroup) {
        InvLogging.finer("Updating group in config: " + worldGroup.getName(), new Object[0]);
        this.getConfig().createSection("groups." + worldGroup.getName(), this.serializeWorldGroupProfile(worldGroup));
    }

    private Map<String, Object> serializeWorldGroupProfile(WorldGroup profile) {
        LinkedHashMap<String, Object> results = new LinkedHashMap<String, Object>();
        results.put("worlds", Lists.newArrayList(profile.getWorlds()));
        List<String> sharesList = profile.getShares().toStringList();
        if (!sharesList.isEmpty()) {
            results.put("shares", sharesList);
        }
        LinkedHashMap<String, String> spawnProps = new LinkedHashMap<String, String>();
        if (profile.getSpawnWorld() != null) {
            spawnProps.put("world", profile.getSpawnWorld());
            spawnProps.put("priority", profile.getSpawnPriority().toString());
            results.put("spawn", spawnProps);
        }
        return results;
    }

    private void removeWorldGroup(WorldGroup worldGroup) {
        InvLogging.finer("Removing group from config: " + worldGroup.getName(), new Object[0]);
        this.getConfig().set("groups." + worldGroup.getName(), null);
    }

    private void save() {
        this.groupsConfig.save();
    }

    @Override
    public void updateGroup(WorldGroup worldGroup) {
        super.updateGroup(worldGroup);
        this.updateWorldGroup(worldGroup);
        this.save();
    }

    @Override
    public boolean removeGroup(WorldGroup worldGroup) {
        if (super.removeGroup(worldGroup)) {
            this.removeWorldGroup(worldGroup);
            this.save();
            return true;
        }
        return false;
    }
}

